/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.utils;

import it.sirius.BaseConstants;
import it.sirius.BaseLoader;
import java.awt.Desktop;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Utils {
    public static byte[] hexStringToByteArray(String s) {
        if (s.length() % 2 != 0) {
            s = "0" + s;
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static int cleanVersion(String version) {
        int v = 0;
        try {
            String[] parts = version.trim().split("\\.");
            v += Integer.parseInt(parts[0]) * 10000;
            v += Integer.parseInt(parts[1]) * 100;
            if (parts.length == 3) {
                v += Integer.parseInt(parts[2]);
            }
            if (parts.length == 4) {
                v += Integer.parseInt(parts[2]);
                v *= 100;
                v += Integer.parseInt(parts[3]);
            }
        }
        catch (Exception e) {
            v = -1;
        }
        return v;
    }

    public static String byteArrayToHex(byte[] a, String separator) {
        StringBuilder sb = new StringBuilder();
        String format = "%02x";
        if (separator != null) {
            format = String.valueOf(format) + separator;
        }
        byte[] byArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format(format, b & 0xFF));
            ++n2;
        }
        return sb.toString().trim().toUpperCase();
    }

    public static String[] splitString(String str, int len) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < str.length()) {
            int endindex = Math.min(i + len, str.length());
            list.add(str.substring(i, endindex));
            i += len;
        }
        return list.toArray(new String[list.size()]);
    }

    public static int executeProcessWindows(String[] commands) {
        int result = -1;
        try {
            Process p1 = Runtime.getRuntime().exec(commands);
            BufferedReader bri = new BufferedReader(new InputStreamReader(p1.getInputStream()));
            BufferedReader bre = new BufferedReader(new InputStreamReader(p1.getErrorStream()));
            bri.close();
            bre.close();
            result = p1.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean checkInternetConnection() {
        boolean status = false;
        Socket sock = new Socket();
        InetSocketAddress address = new InetSocketAddress("www.google.com", 80);
        try {
            try {
                sock.connect(address, 3000);
                if (sock.isConnected()) {
                    status = true;
                }
            }
            catch (Exception e) {
                status = false;
                try {
                    sock.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                sock.close();
            }
            catch (Exception exception) {}
        }
        return status;
    }

    public static String byteArrayToHex(byte[] a) {
        return Utils.byteArrayToHex(a, false);
    }

    public static String byteArrayToHex(byte[] a, boolean separate) {
        StringBuilder sb = new StringBuilder();
        String format = "%02x";
        if (separate) {
            format = String.valueOf(format) + " ";
        }
        byte[] byArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format(format, b & 0xFF));
            ++n2;
        }
        return sb.toString().trim();
    }

    public static String cryptDecrypt(byte[] content) {
        byte[] key = new byte[]{80, 83, 83, 77, 84, 82};
        int noBytes = content.length;
        byte[] crypt = new byte[noBytes + 1];
        String result = "";
        int x = 0;
        while (x < noBytes) {
            crypt[x] = content[x];
            ++x;
        }
        int ii = 0;
        while (ii < crypt.length) {
            char ret = (char)(crypt[ii] ^ key[ii % 4]);
            result = String.valueOf(result) + ret;
            ++ii;
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    public static String cryptDecryptFromFile(String fileName) throws IOException {
        Path p = FileSystems.getDefault().getPath("", fileName);
        byte[] fileData = Files.readAllBytes(p);
        return Utils.cryptDecrypt(fileData);
    }

    public static void writeToFile(String filename, String content) {
        try {
            FileWriter fw = new FileWriter(filename);
            fw.write(content);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readFromFile(String filename) {
        String content;
        block6: {
            content = "";
            try {
                File f = new File(filename);
                if (!f.exists()) break block6;
                try (BufferedReader br = new BufferedReader(new FileReader(filename));){
                    String line = br.readLine();
                    while (line != null) {
                        content = String.valueOf(content) + line;
                        line = br.readLine();
                    }
                }
            }
            catch (Exception e) {
                content = "";
            }
        }
        return content;
    }

    public static void deleteFile(String filename) {
        try {
            File f = new File(filename);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InputStream getInputStreamFromRemoteUrl(String remoteUrl) {
        ByteArrayInputStream is = null;
        try {
            int nRead;
            URL url = new URL(remoteUrl);
            InputStream isTmp = url.openStream();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = isTmp.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            is = new ByteArrayInputStream(buffer.toByteArray());
        }
        catch (Exception e) {
            is = null;
        }
        return is;
    }

    public static InputStream getInputStreamContent(String relativeUrl, boolean offline) {
        InputStream is = null;
        try {
            if (offline) {
                is = Utils.class.getResourceAsStream(relativeUrl);
            } else {
                int nRead;
                URL url = new URL(String.valueOf(new String(BaseConstants.BASE_URL)) + relativeUrl);
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(3000);
                connection.setReadTimeout(3000);
                InputStream isTmp = connection.getInputStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                while ((nRead = isTmp.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                is = new ByteArrayInputStream(buffer.toByteArray());
            }
        }
        catch (Exception e) {
            is = null;
        }
        return is;
    }

    public static String getUpdaterVersion(String relativeUrl, boolean offline) {
        String version = null;
        try {
            int nRead;
            InputStream is = Utils.getInputStreamContent(relativeUrl, offline);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            version = new String(buffer.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return version;
    }

    public static void checkVersion(String release, String relativeUrl, JFrame parent, boolean offline) {
        String latest;
        if (!offline && !Utils.checkInternetConnection()) {
            JOptionPane.showMessageDialog(parent, BaseLoader.messageBundle.getString("loader.server.no_connection"), "Error", 0);
            System.exit(0);
        }
        if ((latest = Utils.getUpdaterVersion(relativeUrl, offline)) != null) {
            int last;
            int curr = Utils.cleanVersion(release);
            if (curr < (last = Utils.cleanVersion(latest))) {
                String message = String.valueOf(BaseLoader.messageBundle.getString("loader.version.check")) + "\n\n";
                message = String.valueOf(message) + BaseLoader.messageBundle.getString("loader.version.current") + "   " + release + "\n";
                message = String.valueOf(message) + BaseLoader.messageBundle.getString("loader.version.latest") + "   " + latest + "\n\n";
                message = String.valueOf(message) + BaseLoader.messageBundle.getString("loader.version.update");
                JLabel label = new JLabel();
                Font font = label.getFont();
                StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
                style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
                style.append("font-size:" + font.getSize() + "pt;");
                JEditorPane ep = new JEditorPane("text/html", "<html><body style=\"" + style + "\">" + message.replace("\n", "<br/>") + "</body></html>");
                ep.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            try {
                                Desktop.getDesktop().browse(e.getURL().toURI());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                ep.setEditable(false);
                ep.setBackground(label.getBackground());
                JOptionPane.showMessageDialog(parent, ep);
                System.exit(0);
            }
        } else {
            JOptionPane.showMessageDialog(parent, BaseLoader.messageBundle.getString("loader.server.no_server"), "Error", 0);
            System.exit(0);
        }
    }

    public static String getMotorVersion(String relativeUrl, boolean offline) {
        String version = null;
        try {
            InputStream is = Utils.getInputStreamContent(relativeUrl, offline);
            Properties config = new Properties();
            config.load(is);
            is.close();
            is = null;
            String fw = config.getProperty("FIRMWARE_VERSION");
            if (fw != null) {
                version = fw = fw.replace("EP3-", "").replace("_", "").trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public static String getMacAddress() {
        String macAddress = null;
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress("www.google.com", 80));
            InetAddress ip = socket.getLocalAddress();
            System.out.println("Current IP address : " + ip.getHostAddress());
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            System.out.print("Current MAC address : ");
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < mac.length) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                ++i;
            }
            macAddress = sb.toString();
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return macAddress;
    }

    public static byte[] flipBytes(byte[] source) {
        byte[] result = new byte[source.length];
        int j = 0;
        int i = source.length;
        while (i > 0) {
            result[j++] = source[i - 1];
            --i;
        }
        return result;
    }
}

