/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.ui;

import it.sirius.Loader;
import it.sirius.console.Commands;
import it.sirius.console.DataPacket;
import it.sirius.console.Serial;
import it.sirius.db.Value;
import it.sirius.db.ValuesList;
import it.sirius.hardware.CheckSumException;
import it.sirius.hardware.Header;
import it.sirius.hardware.MicroDescriptor;
import it.sirius.hardware.MicroLoader;
import it.sirius.hardware.frames.DisplayPacket;
import it.sirius.ui.ChangeLogForm;
import it.sirius.ui.DisplayRecoveryForm;
import it.sirius.ui.EmptyProgressBarUI;
import it.sirius.utils.Utils;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicProgressBarUI;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class LoaderForm
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -6845689516186050114L;
    private static final Logger log = Logger.getLogger(LoaderForm.class.getName());
    public static final int BACK_BTN_EXIT_CODE = 1000;
    public static final int NEXT_BTN_EXIT_CODE = 2000;
    private final boolean ENABLE_BLE = true;
    private final LoaderForm INSTANCE = this;
    private boolean ON_UPDATE = false;
    private boolean ON_RECOVERY = false;
    private Value odometer = null;
    private boolean first = true;
    private boolean UPDATE_MOTOR = true;
    private boolean UPDATE_DISPLAY = true;
    private boolean UPDATE_BLE_CORE = true;
    private boolean UPDATE_BLE_APP = true;
    private boolean UPDATE_FINISHED_MOTOR = false;
    private boolean UPDATE_FINISHED_DISPLAY = false;
    private boolean UPDATE_FINISHED_BLE_CORE = false;
    private boolean UPDATE_FINISHED_BLE_APP = false;
    private boolean UPDATE_FINISHED_WITH_ERROR = false;
    private boolean UPDATE_RECOVERY_MOTOR = false;
    private boolean UPDATE_RECOVERY_DISPLAY = false;
    private boolean UPDATE_RECOVERY_BLE = false;
    private boolean SKIP_CHECK_VERSION = false;
    private boolean isAlreadyUpdateShowed = false;
    public static volatile boolean ENABLE_PING = true;
    public static boolean ON_BIOS = false;
    public static int DISPLAY_TYPE = -1;
    public static int MOTOR_TYPE = -1;
    public static int FW_VER_BOARD = -1;
    public static int DISPLAY_FAMILY = -1;
    public static String BIOS_BOARD = null;
    public static boolean firmwareDetected = false;
    public static String fwVer = null;
    private JLabel lblMessage;
    private JLabel lblSerialPort;
    private JLabel lblCurrentStep;
    private JButton scanButton;
    private JProgressBar overallProgressBar;
    private JProgressBar uploadProgressBar;
    private JLabel lblMotor;
    private JLabel lblMotorLocal;
    private JLabel lblMotorOnline;
    private JLabel lblMotorStatus;
    private JLabel lblDisplay;
    private JLabel lblDisplayLocal;
    private JLabel lblDisplayOnline;
    private JLabel lblDisplayStatus;
    private JLabel lblBleCore;
    private JLabel lblBleCoreLocal;
    private JLabel lblBleCoreOnline;
    private JLabel lblBleCoreStatus;
    private JLabel lblBleApp;
    private JLabel lblBleAppLocal;
    private JLabel lblBleAppOnline;
    private JLabel lblBleAppStatus;
    private JButton btnUpload;
    private int currentStep;
    private SerialHardwarePinger pinger;
    private SerialMotorUpdater motorUpdateWorker;
    private SerialDatabaseStringWriter databaseWorker;
    private SerialDisplayUpdater displayUpdateWorker;
    private SerialBleCoreUpdater bleCoreUpdateWorker;
    private SerialBleAppUpdater bleAppUpdateWorker;
    private MicroLoader ml;
    private final int WINDOWS_VERSION;
    private int firmwareRetry = 150;
    private final ImageIcon passIcon;
    private final ImageIcon failIcon;
    private final ImageIcon uploadIcon;
    private JMenuBar menuBar;
    private JMenu menuOptions;
    private JCheckBoxMenuItem menuItemUpgrade;
    private JCheckBoxMenuItem menuItemDowngrade;
    private JCheckBoxMenuItem menuItemSwitchBattery;
    private JCheckBoxMenuItem menuItemRecoveryMotor;
    private JCheckBoxMenuItem menuItemRecoveryDisplay;
    private JCheckBoxMenuItem menuItemRecoveryBle;
    private JLabel lblRecovery;
    private ChangeLogForm changeLogForm;
    private JButton btnNext;
    private JButton btnBack;

    public LoaderForm() {
        this.setTitle(this.createTitle());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LoaderForm.class.getResource("/img/logo.png")));
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        int w = 610;
        int h = 450;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(d.width / 2 - w / 2, d.height / 2 - h / 2, w, h);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.createMenuFile();
        this.createMenuRecovery(this);
        this.createMenuOptions();
        this.createMenuHelp();
        this.lblMessage = new JLabel(Loader.messageBundle.getString("loader.welcome"));
        this.lblMessage.setFont(new Font("Tahoma", 0, 12));
        this.lblMessage.setBounds(10, 10, 441, 27);
        this.getContentPane().add(this.lblMessage);
        JPanel portPanel = new JPanel();
        portPanel.setBorder(BorderFactory.createEtchedBorder(1));
        portPanel.setLayout(null);
        portPanel.setBounds(461, 10, 123, 30);
        this.getContentPane().add(portPanel);
        this.lblSerialPort = new JLabel("");
        this.lblSerialPort.setFont(new Font("Tahoma", 0, 12));
        this.lblSerialPort.setHorizontalAlignment(0);
        this.lblSerialPort.setBounds(3, 3, 90, 23);
        portPanel.add(this.lblSerialPort);
        this.scanButton = new JButton("");
        this.scanButton.setBounds(96, 3, 23, 23);
        this.scanButton.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(LoaderForm.class.getResource("/img/scan.png"))));
        this.scanButton.addActionListener(this);
        this.scanButton.setActionCommand("scanPorts");
        portPanel.add(this.scanButton);
        JLabel lblStep = new JLabel(Loader.messageBundle.getString("loader.step"));
        lblStep.setFont(new Font("Tahoma", 0, 12));
        lblStep.setBounds(10, 41, 147, 25);
        this.getContentPane().add(lblStep);
        this.lblCurrentStep = new JLabel("---");
        this.lblCurrentStep.setFont(new Font("Tahoma", 0, 12));
        this.lblCurrentStep.setBounds(167, 41, 417, 25);
        this.getContentPane().add(this.lblCurrentStep);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setBounds(10, 78, 575, 25);
        this.overallProgressBar.setForeground(new Color(0, 152, 215));
        this.overallProgressBar.setStringPainted(true);
        this.overallProgressBar.setFont(new Font("Tahoma", 0, 12));
        this.overallProgressBar.setUI(new EmptyProgressBarUI());
        this.getContentPane().add(this.overallProgressBar);
        this.uploadProgressBar = new JProgressBar();
        this.uploadProgressBar.setBounds(10, 110, 575, 25);
        this.uploadProgressBar.setForeground(new Color(0, 202, 231));
        this.uploadProgressBar.setStringPainted(true);
        this.uploadProgressBar.setFont(new Font("Tahoma", 0, 12));
        this.uploadProgressBar.setUI(new EmptyProgressBarUI());
        this.getContentPane().add(this.uploadProgressBar);
        Border border = BorderFactory.createLineBorder(Color.GRAY, 1);
        GridLayout layout = new GridLayout(5, 4);
        layout.setHgap(5);
        layout.setVgap(5);
        JPanel grid = new JPanel();
        grid.setBounds(10, 146, 574, 198);
        grid.setLayout(layout);
        this.getContentPane().add(grid);
        this.lblRecovery = new JLabel("RECOVERY");
        this.lblRecovery.setFont(new Font("Tahoma", 0, 14));
        this.lblRecovery.setHorizontalAlignment(0);
        this.lblRecovery.setOpaque(true);
        this.lblRecovery.setForeground(Color.BLACK);
        this.lblRecovery.setBackground(new Color(255, 127, 39));
        this.lblRecovery.setVisible(false);
        JLabel lblEbike = new JLabel(Loader.messageBundle.getString("loader.grid.ebike"));
        lblEbike.setFont(new Font("Tahoma", 0, 14));
        lblEbike.setHorizontalAlignment(0);
        JLabel lblOnline = new JLabel(Loader.messageBundle.getString("loader.grid.online"));
        lblOnline.setFont(new Font("Tahoma", 0, 14));
        lblOnline.setHorizontalAlignment(0);
        JLabel lblStatus = new JLabel(Loader.messageBundle.getString("loader.grid.status"));
        lblStatus.setFont(new Font("Tahoma", 0, 14));
        lblStatus.setHorizontalAlignment(0);
        this.lblMotor = new JLabel(Loader.messageBundle.getString("loader.grid.motor"));
        this.lblMotor.setFont(new Font("Tahoma", 0, 14));
        this.lblMotor.setHorizontalAlignment(0);
        this.lblDisplay = new JLabel(Loader.messageBundle.getString("loader.grid.display"));
        this.lblDisplay.setFont(new Font("Tahoma", 0, 14));
        this.lblDisplay.setHorizontalAlignment(0);
        this.lblBleCore = new JLabel(Loader.messageBundle.getString("loader.grid.ble.core"));
        this.lblBleCore.setFont(new Font("Tahoma", 0, 14));
        this.lblBleCore.setHorizontalAlignment(0);
        this.lblBleApp = new JLabel(Loader.messageBundle.getString("loader.grid.ble.app"));
        this.lblBleApp.setFont(new Font("Tahoma", 0, 14));
        this.lblBleApp.setHorizontalAlignment(0);
        this.lblMotorLocal = new JLabel("");
        this.lblMotorLocal.setHorizontalAlignment(0);
        this.lblMotorLocal.setBorder(border);
        this.lblMotorOnline = new JLabel("");
        this.lblMotorOnline.setHorizontalAlignment(0);
        this.lblMotorOnline.setBorder(border);
        this.lblMotorStatus = new JLabel("");
        this.lblMotorStatus.setHorizontalAlignment(0);
        this.lblMotorStatus.setBorder(border);
        this.lblDisplayLocal = new JLabel("");
        this.lblDisplayLocal.setHorizontalAlignment(0);
        this.lblDisplayLocal.setBorder(border);
        this.lblDisplayOnline = new JLabel("");
        this.lblDisplayOnline.setHorizontalAlignment(0);
        this.lblDisplayOnline.setBorder(border);
        this.lblDisplayStatus = new JLabel("");
        this.lblDisplayStatus.setHorizontalAlignment(0);
        this.lblDisplayStatus.setBorder(border);
        this.lblBleCoreLocal = new JLabel("");
        this.lblBleCoreLocal.setHorizontalAlignment(0);
        this.lblBleCoreLocal.setBorder(border);
        this.lblBleCoreOnline = new JLabel("");
        this.lblBleCoreOnline.setHorizontalAlignment(0);
        this.lblBleCoreOnline.setBorder(border);
        this.lblBleCoreStatus = new JLabel("");
        this.lblBleCoreStatus.setHorizontalAlignment(0);
        this.lblBleCoreStatus.setBorder(border);
        this.lblBleAppLocal = new JLabel("");
        this.lblBleAppLocal.setHorizontalAlignment(0);
        this.lblBleAppLocal.setBorder(border);
        this.lblBleAppOnline = new JLabel("");
        this.lblBleAppOnline.setHorizontalAlignment(0);
        this.lblBleAppOnline.setBorder(border);
        this.lblBleAppStatus = new JLabel("");
        this.lblBleAppStatus.setHorizontalAlignment(0);
        this.lblBleAppStatus.setBorder(border);
        grid.add(this.lblRecovery);
        grid.add(lblEbike);
        grid.add(lblOnline);
        grid.add(lblStatus);
        grid.add(this.lblDisplay);
        grid.add(this.lblDisplayLocal);
        grid.add(this.lblDisplayOnline);
        grid.add(this.lblDisplayStatus);
        grid.add(this.lblMotor);
        grid.add(this.lblMotorLocal);
        grid.add(this.lblMotorOnline);
        grid.add(this.lblMotorStatus);
        grid.add(this.lblBleCore);
        grid.add(this.lblBleCoreLocal);
        grid.add(this.lblBleCoreOnline);
        grid.add(this.lblBleCoreStatus);
        grid.add(this.lblBleApp);
        grid.add(this.lblBleAppLocal);
        grid.add(this.lblBleAppOnline);
        grid.add(this.lblBleAppStatus);
        this.passIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(LoaderForm.class.getResource("/img/pass_32.png")));
        this.failIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(LoaderForm.class.getResource("/img/fail_32.png")));
        this.uploadIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(LoaderForm.class.getResource("/img/download_32.png")));
        this.btnUpload = new JButton(Loader.messageBundle.getString("loader.button_update"));
        this.btnUpload.addActionListener(this);
        this.btnUpload.setActionCommand("updateFirmware");
        this.btnUpload.setFont(new Font("Tahoma", 0, 12));
        this.btnUpload.setBounds(235, 365, 150, 23);
        this.getContentPane().add(this.btnUpload);
        this.btnUpload.setEnabled(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoaderForm.this.closeAndExit();
            }
        });
        this.scanButton.setEnabled(true);
        this.WINDOWS_VERSION = this.getWindowsVersion();
        if (this.WINDOWS_VERSION < 0) {
            JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.windows_not_supported"), "Error", 0);
            System.exit(0);
        }
        SwingWorker<Void, Void> setupVersion = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Utils.checkVersion("6.14.19", "/bin/Updater/Updater.txt", LoaderForm.this.INSTANCE, Loader.offline);
                System.out.println("check version done.");
                return null;
            }
        };
        if (!Loader.isExternalLaunch()) {
            setupVersion.execute();
        }
        this.overallProgressBar.setString(Loader.messageBundle.getString("loader.findingMotor"));
        this.uploadProgressBar.setString(Loader.messageBundle.getString("loader.waiting"));
        SwingWorker<Void, Void> setupSerial = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                LoaderForm.this.scanSerialPorts();
                System.out.println("scan serial ports done.");
                return null;
            }
        };
        setupSerial.execute();
        this.overallProgressBar.setMinimum(0);
        this.overallProgressBar.setMaximum(0);
        this.overallProgressBar.setValue(0);
        this.uploadProgressBar.setMinimum(0);
        this.uploadProgressBar.setMaximum(0);
        this.uploadProgressBar.setValue(0);
        this.btnBack = new JButton("Back");
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(1000);
            }
        });
        this.btnBack.setBounds(75, 365, 150, 23);
        this.btnBack.setVisible(Loader.isPSSLaunch() || Loader.isDealerLaunch());
        this.getContentPane().add(this.btnBack);
        this.btnNext = new JButton("Next");
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(2000);
            }
        });
        this.btnNext.setBounds(395, 365, 150, 23);
        this.btnNext.setVisible(Loader.isPSSLaunch() || Loader.isDealerLaunch());
        this.getContentPane().add(this.btnNext);
        this.changeLogForm = new ChangeLogForm(this);
        if (!Loader.isPSSLaunch() && !Loader.isDealerLaunch()) {
            this.btnUpload.setBounds(10, this.btnUpload.getBounds().y, this.btnUpload.getBounds().width, this.btnUpload.getBounds().height);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "scanPorts": {
                this.scanSerialPorts();
                break;
            }
            case "updateFirmware": {
                new UpdateManager().execute();
                break;
            }
        }
    }

    private void closeAndExit() {
        try {
            this.stopPinger();
            Serial.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
        System.exit(0);
    }

    private void createMenuFile() {
        JMenu menu = new JMenu(Loader.messageBundle.getString("loader.menu.file"));
        menu.setFont(new Font("Tahoma", 0, 11));
        JMenuItem menuItemExit = new JMenuItem(Loader.messageBundle.getString("loader.menu.file.exit"));
        menuItemExit.setFont(new Font("Tahoma", 0, 11));
        menuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoaderForm.this.closeAndExit();
            }
        });
        menu.add(menuItemExit);
        this.menuBar.add(menu);
    }

    private void createMenuRecovery(final JFrame parent) {
        JMenu menu = new JMenu("Recovery");
        menu.setFont(new Font("Tahoma", 0, 11));
        this.menuItemRecoveryDisplay = new JCheckBoxMenuItem(Loader.messageBundle.getString("loader.menu.options.recovery.display"));
        this.menuItemRecoveryDisplay.setFont(new Font("Tahoma", 0, 11));
        this.menuItemRecoveryDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LoaderForm.this.menuItemRecoveryDisplay.isSelected()) {
                    LoaderForm.this.ON_UPDATE = true;
                    LoaderForm.this.configureSteps();
                    DisplayRecoveryForm d = new DisplayRecoveryForm(parent);
                    if (d.getModalResult()) {
                        DISPLAY_FAMILY = d.getDisplayType();
                        LoaderForm.this.UPDATE_RECOVERY_DISPLAY = true;
                        LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                        LoaderForm.this.menuItemRecoveryBle.setSelected(false);
                        LoaderForm.this.configureSteps();
                        LoaderForm.this.btnUpload.setVisible(false);
                        LoaderForm.this.menuItemRecoveryMotor.setEnabled(false);
                        LoaderForm.this.menuItemRecoveryBle.setEnabled(false);
                        new UpdateManager().execute();
                    } else {
                        LoaderForm.this.ON_UPDATE = false;
                        LoaderForm.this.UPDATE_RECOVERY_MOTOR = false;
                        LoaderForm.this.UPDATE_RECOVERY_DISPLAY = false;
                        LoaderForm.this.UPDATE_RECOVERY_BLE = false;
                        LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                        LoaderForm.this.menuItemRecoveryDisplay.setSelected(false);
                        LoaderForm.this.menuItemRecoveryBle.setSelected(false);
                        LoaderForm.this.configureSteps();
                        LoaderForm.this.btnUpload.setVisible(true);
                    }
                } else {
                    LoaderForm.this.ON_UPDATE = false;
                    LoaderForm.this.UPDATE_RECOVERY_MOTOR = false;
                    LoaderForm.this.UPDATE_RECOVERY_DISPLAY = false;
                    LoaderForm.this.UPDATE_RECOVERY_BLE = false;
                    LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                    LoaderForm.this.menuItemRecoveryDisplay.setSelected(false);
                    LoaderForm.this.menuItemRecoveryBle.setSelected(false);
                    LoaderForm.this.configureSteps();
                    LoaderForm.this.btnUpload.setVisible(true);
                }
            }
        });
        menu.add(this.menuItemRecoveryDisplay);
        this.menuItemRecoveryMotor = new JCheckBoxMenuItem(Loader.messageBundle.getString("loader.menu.options.recovery.motor"));
        this.menuItemRecoveryMotor.setFont(new Font("Tahoma", 0, 11));
        this.menuItemRecoveryMotor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                    if (!ON_BIOS) {
                        LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                        JOptionPane.showMessageDialog(null, Loader.messageBundle.getString("loader.update.recovery_bios"), "Info", 2);
                        return;
                    }
                    LoaderForm.this.ON_UPDATE = true;
                    LoaderForm.this.configureSteps();
                    int input = JOptionPane.showConfirmDialog(null, String.valueOf(Loader.messageBundle.getString("loader.recovery.warning_check.motor")) + "\n\n" + Loader.messageBundle.getString("loader.recovery.warning"), "Update status", 0, 1);
                    if (input != 0) {
                        LoaderForm.this.ON_UPDATE = false;
                        LoaderForm.this.UPDATE_RECOVERY_MOTOR = false;
                        LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                        LoaderForm.this.menuItemRecoveryDisplay.setSelected(false);
                        LoaderForm.this.menuItemRecoveryBle.setSelected(false);
                        LoaderForm.this.configureSteps();
                        return;
                    }
                    LoaderForm.this.menuItemRecoveryDisplay.setSelected(false);
                    LoaderForm.this.menuItemRecoveryBle.setSelected(false);
                    LoaderForm.this.configureSteps();
                    LoaderForm.this.btnUpload.setVisible(false);
                    LoaderForm.this.menuItemRecoveryDisplay.setEnabled(false);
                    LoaderForm.this.menuItemRecoveryBle.setEnabled(false);
                    new UpdateManager().execute();
                } else {
                    LoaderForm.this.ON_UPDATE = false;
                    LoaderForm.this.UPDATE_RECOVERY_MOTOR = false;
                    LoaderForm.this.UPDATE_RECOVERY_DISPLAY = false;
                    LoaderForm.this.UPDATE_RECOVERY_BLE = false;
                    LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                    LoaderForm.this.menuItemRecoveryDisplay.setSelected(false);
                    LoaderForm.this.menuItemRecoveryBle.setSelected(false);
                    LoaderForm.this.configureSteps();
                    LoaderForm.this.btnUpload.setVisible(true);
                }
            }
        });
        menu.add(this.menuItemRecoveryMotor);
        this.menuItemRecoveryBle = new JCheckBoxMenuItem(Loader.messageBundle.getString("loader.menu.options.recovery.ble"));
        this.menuItemRecoveryBle.setFont(new Font("Tahoma", 0, 11));
        this.menuItemRecoveryBle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LoaderForm.this.menuItemRecoveryBle.isSelected()) {
                    LoaderForm.this.ON_UPDATE = true;
                    LoaderForm.this.configureSteps();
                    int input = JOptionPane.showConfirmDialog(null, String.valueOf(Loader.messageBundle.getString("loader.recovery.warning_check.ble")) + "\n\n" + Loader.messageBundle.getString("loader.recovery.warning"), "Update status", 0, 1);
                    if (input != 0) {
                        LoaderForm.this.ON_UPDATE = false;
                        LoaderForm.this.UPDATE_RECOVERY_MOTOR = false;
                        LoaderForm.this.UPDATE_RECOVERY_DISPLAY = false;
                        LoaderForm.this.UPDATE_RECOVERY_BLE = false;
                        LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                        LoaderForm.this.menuItemRecoveryDisplay.setSelected(false);
                        LoaderForm.this.menuItemRecoveryBle.setSelected(false);
                        LoaderForm.this.configureSteps();
                        LoaderForm.this.btnUpload.setVisible(true);
                        return;
                    }
                    LoaderForm.this.UPDATE_RECOVERY_BLE = true;
                    LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                    LoaderForm.this.menuItemRecoveryDisplay.setSelected(false);
                    LoaderForm.this.btnUpload.setVisible(false);
                    LoaderForm.this.menuItemRecoveryDisplay.setEnabled(false);
                    LoaderForm.this.menuItemRecoveryMotor.setEnabled(false);
                    new UpdateManager().execute();
                } else {
                    LoaderForm.this.ON_UPDATE = false;
                    LoaderForm.this.UPDATE_RECOVERY_MOTOR = false;
                    LoaderForm.this.UPDATE_RECOVERY_DISPLAY = false;
                    LoaderForm.this.UPDATE_RECOVERY_BLE = false;
                    LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                    LoaderForm.this.menuItemRecoveryDisplay.setSelected(false);
                    LoaderForm.this.menuItemRecoveryBle.setSelected(false);
                    LoaderForm.this.configureSteps();
                    LoaderForm.this.btnUpload.setVisible(true);
                }
            }
        });
        menu.add(this.menuItemRecoveryBle);
        this.menuBar.add(menu);
    }

    private void createMenuOptions() {
        this.menuOptions = new JMenu(Loader.messageBundle.getString("loader.menu.options"));
        this.menuOptions.setFont(new Font("Tahoma", 0, 11));
        this.menuItemUpgrade = new JCheckBoxMenuItem(Loader.messageBundle.getString("loader.menu.options.upgrade.display"));
        this.menuItemUpgrade.setFont(new Font("Tahoma", 0, 11));
        this.menuItemUpgrade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LoaderForm.this.menuItemUpgrade.isSelected()) {
                    int input = JOptionPane.showConfirmDialog(null, String.valueOf(Loader.messageBundle.getString("loader.menu.options.upgrade.display")) + "?", "Update status", 0, 1);
                    if (input == 0) {
                        LoaderForm.this.stopPinger();
                        if (Serial.sendWriteVarString("PoliniDisplay", "2")) {
                            try {
                                Thread.sleep(1000L);
                                DISPLAY_FAMILY = 3;
                                LoaderForm.this.lblDisplay.setVisible(true);
                                LoaderForm.this.lblDisplayLocal.setVisible(true);
                                LoaderForm.this.lblDisplayOnline.setVisible(true);
                                LoaderForm.this.lblDisplayStatus.setVisible(true);
                                LoaderForm.this.lblDisplayOnline.setText(LoaderForm.this.getDisplayVersion("displayV3.txt"));
                                LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.uploadIcon);
                                LoaderForm.this.lblMotor.setVisible(false);
                                LoaderForm.this.lblMotorLocal.setVisible(false);
                                LoaderForm.this.lblMotorOnline.setVisible(false);
                                LoaderForm.this.lblMotorStatus.setVisible(false);
                                LoaderForm.this.lblBleCore.setVisible(false);
                                LoaderForm.this.lblBleCoreLocal.setVisible(false);
                                LoaderForm.this.lblBleCoreOnline.setVisible(false);
                                LoaderForm.this.lblBleCoreStatus.setVisible(false);
                                LoaderForm.this.lblBleApp.setVisible(false);
                                LoaderForm.this.lblBleAppLocal.setVisible(false);
                                LoaderForm.this.lblBleAppOnline.setVisible(false);
                                LoaderForm.this.lblBleAppStatus.setVisible(false);
                                String displayVersion = "";
                                try {
                                    displayVersion = LoaderForm.this.getSerialDisplayVersion();
                                }
                                catch (Exception e) {
                                    displayVersion = "---";
                                }
                                LoaderForm.this.lblDisplayLocal.setText(displayVersion);
                                LoaderForm.this.ON_RECOVERY = false;
                                LoaderForm.this.UPDATE_MOTOR = false;
                                LoaderForm.this.UPDATE_DISPLAY = true;
                                LoaderForm.this.UPDATE_BLE_CORE = false;
                                LoaderForm.this.UPDATE_BLE_APP = false;
                                new UpdateManager().execute();
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        LoaderForm.this.menuItemUpgrade.setSelected(false);
                    }
                }
            }
        });
        this.menuItemDowngrade = new JCheckBoxMenuItem(Loader.messageBundle.getString("loader.menu.options.downgrade.display"));
        this.menuItemDowngrade.setFont(new Font("Tahoma", 0, 11));
        this.menuItemDowngrade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LoaderForm.this.menuItemDowngrade.isSelected()) {
                    int input = JOptionPane.showConfirmDialog(null, String.valueOf(Loader.messageBundle.getString("loader.menu.options.downgrade.display")) + "?", "Update status", 0, 1);
                    if (input == 0) {
                        LoaderForm.this.stopPinger();
                        if (Serial.sendWriteVarString("PoliniDisplay", "0")) {
                            try {
                                Thread.sleep(500L);
                                DISPLAY_FAMILY = 0;
                                LoaderForm.this.lblDisplay.setVisible(false);
                                LoaderForm.this.lblDisplayLocal.setVisible(false);
                                LoaderForm.this.lblDisplayOnline.setVisible(false);
                                LoaderForm.this.lblDisplayStatus.setVisible(false);
                                LoaderForm.this.lblDisplayOnline.setText("");
                                LoaderForm.this.lblDisplayStatus.setIcon(null);
                                LoaderForm.this.lblMotor.setVisible(true);
                                LoaderForm.this.lblMotorLocal.setVisible(true);
                                LoaderForm.this.lblMotorOnline.setVisible(true);
                                LoaderForm.this.lblMotorStatus.setVisible(true);
                                LoaderForm.this.lblBleCore.setVisible(false);
                                LoaderForm.this.lblBleCoreLocal.setVisible(false);
                                LoaderForm.this.lblBleCoreOnline.setVisible(false);
                                LoaderForm.this.lblBleCoreStatus.setVisible(false);
                                LoaderForm.this.lblBleApp.setVisible(false);
                                LoaderForm.this.lblBleAppLocal.setVisible(false);
                                LoaderForm.this.lblBleAppOnline.setVisible(false);
                                LoaderForm.this.lblBleAppStatus.setVisible(false);
                                LoaderForm.this.ON_RECOVERY = false;
                                LoaderForm.this.UPDATE_MOTOR = false;
                                LoaderForm.this.UPDATE_DISPLAY = false;
                                LoaderForm.this.UPDATE_BLE_CORE = false;
                                LoaderForm.this.UPDATE_BLE_APP = false;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            JOptionPane.showMessageDialog(null, Loader.getMsgUpdateSuccess(), "Warning", 1);
                        }
                        LoaderForm.this.startPinger();
                    } else {
                        LoaderForm.this.menuItemDowngrade.setSelected(false);
                    }
                }
            }
        });
        this.menuItemSwitchBattery = new JCheckBoxMenuItem(Loader.messageBundle.getString("loader.menu.options.switch.battery"));
        this.menuItemSwitchBattery.setFont(new Font("Tahoma", 0, 11));
        this.menuItemSwitchBattery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = JOptionPane.showConfirmDialog(null, Loader.messageBundle.getString("loader.menu.options.switch.battery.warning"), Loader.messageBundle.getString("loader.menu.options.switch.battery"), 1, 2);
                switch (c) {
                    case 0: {
                        if (!Serial.sendWriteVarString("PoliniBattery", "3")) {
                            JOptionPane.showMessageDialog(null, Loader.messageBundle.getString("loader.menu.options.switch.battery.failure"));
                            break;
                        }
                        JOptionPane.showMessageDialog(null, Loader.messageBundle.getString("loader.menu.options.switch.battery.success"));
                        break;
                    }
                }
            }
        });
        this.menuItemSwitchBattery.setVisible(false);
        this.menuOptions.add(this.menuItemUpgrade);
        this.menuOptions.add(this.menuItemDowngrade);
        this.menuOptions.add(this.menuItemSwitchBattery);
        this.menuBar.add(this.menuOptions);
        this.menuOptions.setVisible(false);
    }

    private void createMenuHelp() {
        JMenu menu = new JMenu(Loader.messageBundle.getString("loader.menu.help"));
        menu.setFont(new Font("Tahoma", 0, 11));
        JMenuItem menuItemHelpEp3 = new JMenuItem(String.valueOf(Loader.messageBundle.getString("loader.menu.help.online")) + " EP3... ");
        menuItemHelpEp3.setFont(new Font("Tahoma", 0, 11));
        menuItemHelpEp3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    URI uri = new URI("https://www.poliniebike.com/polini-e-p3/");
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(menuItemHelpEp3);
        this.menuBar.add(menu);
        JMenuItem menuItemHelpEp3Plus = new JMenuItem(String.valueOf(Loader.messageBundle.getString("loader.menu.help.online")) + " EP3+...");
        menuItemHelpEp3Plus.setFont(new Font("Tahoma", 0, 11));
        menuItemHelpEp3Plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    URI uri = new URI("https://www.poliniebike.com/polini-e-p3-5/");
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(menuItemHelpEp3Plus);
        this.menuBar.add(menu);
    }

    private void scanSerialPorts() {
        log.info("start scanSerialPorts...");
        try {
            this.lblSerialPort.setText("");
            this.btnUpload.setEnabled(false);
            this.stopPinger();
            Serial.closeConnection();
            Object[] ports = SerialPortList.getPortNames();
            log.info("serial ports found: " + Arrays.toString(ports));
            if (ports == null || ports.length == 0) {
                JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.no_serial"), "Warning", 2);
                this.scanButton.setEnabled(true);
                return;
            }
            boolean found = false;
            Object[] objectArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                Object port = objectArray[n2];
                log.info("check board at serial port: " + (String)port);
                try {
                    Serial.openConnection((String)port, 115200);
                    log.info("send hwver var request: " + (String)port);
                    Serial.sendReadVarString("HWVer");
                    DataPacket sp = Serial.getSerialResponse((byte)22, 200L);
                    Serial.closeConnection();
                    if (sp != null) {
                        log.info("response: " + sp.data);
                        String data = new String(sp.data).toUpperCase();
                        if (data.contains("MRC") || data.contains("MTI")) {
                            found = true;
                            this.lblSerialPort.setText((String)port);
                            log.info("serial port board found!");
                            break;
                        }
                    } else {
                        log.info("no response");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            if (!found) {
                JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.no_ebike"), "Warning", 2);
                return;
            }
            Thread.sleep(3000L);
            this.startPinger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configureSteps() {
        this.lblRecovery.setVisible(this.menuItemRecoveryMotor.isSelected() || this.menuItemRecoveryDisplay.isSelected() || this.menuItemRecoveryBle.isSelected());
        this.lblMotor.setVisible(true);
        this.lblMotorLocal.setVisible(true);
        this.lblMotorOnline.setVisible(true);
        this.lblMotorStatus.setVisible(true);
        this.lblDisplay.setVisible(true);
        this.lblDisplayLocal.setVisible(true);
        this.lblDisplayOnline.setVisible(true);
        this.lblDisplayStatus.setVisible(true);
        this.lblBleCore.setVisible(true);
        this.lblBleCoreLocal.setVisible(true);
        this.lblBleCoreOnline.setVisible(true);
        this.lblBleCoreStatus.setVisible(true);
        this.lblBleApp.setVisible(true);
        this.lblBleAppLocal.setVisible(true);
        this.lblBleAppOnline.setVisible(true);
        this.lblBleAppStatus.setVisible(true);
        if (this.UPDATE_RECOVERY_MOTOR || this.menuItemRecoveryMotor.isSelected()) {
            this.lblDisplay.setVisible(false);
            this.lblDisplayLocal.setVisible(false);
            this.lblDisplayOnline.setVisible(false);
            this.lblDisplayStatus.setVisible(false);
            this.lblBleCore.setVisible(false);
            this.lblBleCoreLocal.setVisible(false);
            this.lblBleCoreOnline.setVisible(false);
            this.lblBleCoreStatus.setVisible(false);
            this.lblBleApp.setVisible(false);
            this.lblBleAppLocal.setVisible(false);
            this.lblBleAppOnline.setVisible(false);
            this.lblBleAppStatus.setVisible(false);
            this.lblMotorStatus.setIcon(this.uploadIcon);
        }
        if (this.UPDATE_RECOVERY_DISPLAY || this.menuItemRecoveryDisplay.isSelected()) {
            this.lblMotor.setVisible(false);
            this.lblMotorLocal.setVisible(false);
            this.lblMotorOnline.setVisible(false);
            this.lblMotorStatus.setVisible(false);
            this.lblBleCore.setVisible(false);
            this.lblBleCoreLocal.setVisible(false);
            this.lblBleCoreOnline.setVisible(false);
            this.lblBleCoreStatus.setVisible(false);
            this.lblBleApp.setVisible(false);
            this.lblBleAppLocal.setVisible(false);
            this.lblBleAppOnline.setVisible(false);
            this.lblBleAppStatus.setVisible(false);
            this.lblDisplayStatus.setIcon(this.uploadIcon);
        }
        if (this.UPDATE_RECOVERY_BLE || this.menuItemRecoveryBle.isSelected()) {
            this.lblMotor.setVisible(false);
            this.lblMotorLocal.setVisible(false);
            this.lblMotorOnline.setVisible(false);
            this.lblMotorStatus.setVisible(false);
            this.lblDisplay.setVisible(false);
            this.lblDisplayLocal.setVisible(false);
            this.lblDisplayOnline.setVisible(false);
            this.lblDisplayStatus.setVisible(false);
        }
    }

    private void startPinger() {
        this.uploadProgressBar.setValue(0);
        firmwareDetected = false;
        ENABLE_PING = true;
        this.pinger = new SerialHardwarePinger();
        this.pinger.execute();
    }

    private void stopPinger() {
        try {
            ENABLE_PING = false;
            Thread.sleep(500L);
            if (this.pinger != null) {
                this.pinger = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void serialMotorUpdate() {
        block44: {
            block48: {
                block46: {
                    block42: {
                        block45: {
                            block41: {
                                block43: {
                                    if (!this.menuItemRecoveryMotor.isSelected()) break block43;
                                    if (!ON_BIOS) {
                                        this.menuItemRecoveryMotor.setSelected(false);
                                        JOptionPane.showMessageDialog(null, Loader.messageBundle.getString("loader.update.recovery_bios"), "Info", 2);
                                        this.UPDATE_FINISHED_MOTOR = true;
                                        this.UPDATE_FINISHED_WITH_ERROR = true;
                                        return;
                                    }
                                    this.UPDATE_RECOVERY_MOTOR = true;
                                    this.btnUpload.setEnabled(false);
                                    this.scanButton.setEnabled(false);
                                    this.menuItemRecoveryMotor.setEnabled(false);
                                    this.menuItemRecoveryDisplay.setEnabled(false);
                                    this.stopPinger();
                                    this.motorUpdateWorker = new SerialMotorUpdater();
                                    this.motorUpdateWorker.execute();
                                    break block44;
                                }
                                this.btnUpload.setEnabled(false);
                                this.scanButton.setEnabled(false);
                                this.menuItemRecoveryMotor.setEnabled(false);
                                this.menuItemRecoveryDisplay.setEnabled(false);
                                this.stopPinger();
                                ++this.currentStep;
                                this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_1"));
                                this.overallProgressBar.setValue(this.currentStep);
                                if (FW_VER_BOARD < 40000) break block45;
                                BIOS_BOARD = "MRC2";
                                String url = "/bin/" + Loader.folder + "/" + BIOS_BOARD + "_" + DISPLAY_TYPE + "/config.properties";
                                String tmp = Utils.getMotorVersion(url, Loader.offline);
                                this.lblMotorOnline.setText(tmp);
                                int FW_VER_LOADER = Utils.cleanVersion(tmp);
                                if (FW_VER_LOADER < 0) {
                                    JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.update.no_update"), "Warning", 2);
                                    this.startPinger();
                                    this.btnUpload.setEnabled(true);
                                    this.scanButton.setEnabled(true);
                                    this.menuItemRecoveryMotor.setEnabled(true);
                                    this.menuItemRecoveryDisplay.setEnabled(true);
                                    this.menuItemRecoveryMotor.setSelected(false);
                                    this.configureSteps();
                                    this.UPDATE_FINISHED_MOTOR = true;
                                    this.UPDATE_FINISHED_WITH_ERROR = true;
                                    return;
                                }
                                try {
                                    if (!ON_BIOS) {
                                        Serial.sendReboot();
                                        Thread.sleep(250L);
                                        try {
                                            Serial.closeConnection();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        Thread.sleep(100L);
                                        this.SKIP_CHECK_VERSION = true;
                                        ON_BIOS = false;
                                        this.startPinger();
                                        this.firmwareRetry = 150;
                                        while (!ON_BIOS) {
                                            Thread.sleep(100L);
                                            --this.firmwareRetry;
                                            if (this.firmwareRetry > 0) continue;
                                            JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.update.no_bios"), "Error", 2);
                                            this.btnUpload.setEnabled(true);
                                            this.scanButton.setEnabled(true);
                                            this.menuItemRecoveryMotor.setEnabled(true);
                                            this.menuItemRecoveryDisplay.setEnabled(true);
                                            if (this.menuItemRecoveryMotor.isSelected()) {
                                                this.menuItemRecoveryMotor.setSelected(false);
                                                this.configureSteps();
                                            }
                                            return;
                                        }
                                        this.stopPinger();
                                        break block41;
                                    }
                                    JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.update.turn_on_bike"), "Warning", 2);
                                    this.startPinger();
                                    this.btnUpload.setEnabled(true);
                                    this.scanButton.setEnabled(true);
                                    this.menuItemRecoveryMotor.setEnabled(true);
                                    this.menuItemRecoveryDisplay.setEnabled(true);
                                    if (this.menuItemRecoveryMotor.isSelected()) {
                                        this.menuItemRecoveryMotor.setSelected(false);
                                        this.configureSteps();
                                    }
                                    return;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.motorUpdateWorker = new SerialMotorUpdater();
                            this.motorUpdateWorker.execute();
                            break block44;
                        }
                        if (FW_VER_BOARD > 25500 && FW_VER_BOARD < 27700) {
                            try {
                                String val = this.getOdometerM();
                                if (!val.isEmpty()) {
                                    this.odometer = new Value("odometer[m]", val);
                                }
                            }
                            catch (Exception val) {
                                // empty catch block
                            }
                        }
                        try {
                            if (!ON_BIOS) {
                                Serial.sendReboot();
                                Thread.sleep(250L);
                                try {
                                    Serial.closeConnection();
                                }
                                catch (Exception val) {
                                    // empty catch block
                                }
                                Thread.sleep(100L);
                                this.SKIP_CHECK_VERSION = true;
                                ON_BIOS = false;
                                this.startPinger();
                                this.firmwareRetry = 150;
                                while (!ON_BIOS) {
                                    Thread.sleep(100L);
                                    --this.firmwareRetry;
                                    if (this.firmwareRetry > 0) continue;
                                    JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.update.no_bios"), "Error", 2);
                                    this.btnUpload.setEnabled(true);
                                    this.scanButton.setEnabled(true);
                                    this.menuItemRecoveryMotor.setEnabled(true);
                                    this.menuItemRecoveryDisplay.setEnabled(true);
                                    this.menuItemRecoveryMotor.setSelected(false);
                                    this.configureSteps();
                                    this.UPDATE_FINISHED_MOTOR = true;
                                    this.UPDATE_FINISHED_WITH_ERROR = true;
                                    return;
                                }
                                this.stopPinger();
                                String ver = this.getFWVersion();
                                if (ver.toUpperCase().contains("BIOS")) {
                                    BIOS_BOARD = ver.substring(0, ver.indexOf("-"));
                                }
                                break block42;
                            }
                            JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.update.turn_on_bike"), "Warning", 2);
                            this.startPinger();
                            this.btnUpload.setEnabled(true);
                            this.scanButton.setEnabled(true);
                            this.menuItemRecoveryMotor.setEnabled(true);
                            this.menuItemRecoveryDisplay.setEnabled(true);
                            this.menuItemRecoveryMotor.setSelected(false);
                            this.configureSteps();
                            this.UPDATE_FINISHED_MOTOR = true;
                            this.UPDATE_FINISHED_WITH_ERROR = true;
                            return;
                        }
                        catch (Exception ver) {
                            // empty catch block
                        }
                    }
                    if (DISPLAY_TYPE >= 0) break block46;
                    switch (BIOS_BOARD) {
                        case "MRC1": {
                            DISPLAY_TYPE = 0;
                            break;
                        }
                        case "MRC2": {
                            DISPLAY_TYPE = 1;
                        }
                    }
                }
                if (MOTOR_TYPE >= 0) break block48;
                switch (BIOS_BOARD) {
                    case "MRC1": {
                        MOTOR_TYPE = 0;
                    }
                }
            }
            String url = "/bin/" + Loader.folder + "/" + BIOS_BOARD + "_" + DISPLAY_TYPE + "/config.properties";
            String tmp = Utils.getMotorVersion(url, Loader.offline);
            tmp = tmp.replace("MTI-", "");
            this.lblMotorOnline.setText(tmp);
            int FW_VER_LOADER = Utils.cleanVersion(tmp);
            if (FW_VER_LOADER < 0) {
                JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.update.no_update"), "Warning", 2);
                this.startPinger();
                this.btnUpload.setEnabled(true);
                this.scanButton.setEnabled(true);
                this.menuItemRecoveryMotor.setEnabled(true);
                this.menuItemRecoveryDisplay.setEnabled(true);
                if (this.menuItemRecoveryMotor.isSelected()) {
                    this.menuItemRecoveryMotor.setSelected(false);
                    this.configureSteps();
                }
                this.UPDATE_FINISHED_MOTOR = true;
                this.UPDATE_FINISHED_WITH_ERROR = true;
                return;
            }
            if (FW_VER_BOARD >= FW_VER_LOADER) {
                this.UPDATE_FINISHED_MOTOR = true;
                return;
            }
            this.motorUpdateWorker = new SerialMotorUpdater();
            this.motorUpdateWorker.execute();
        }
    }

    private String getDisplayVersion(String filename) {
        String version = null;
        try {
            int nRead;
            InputStream is = Utils.getInputStreamContent("/bin/" + Loader.folder + "/DisplayCD/" + filename, Loader.offline);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            version = new String(buffer.toByteArray());
            this.lblDisplayOnline.setText(version);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    private String getBleAppVersion() {
        String version = null;
        try {
            int nRead;
            InputStream is = Utils.getInputStreamContent("/bin/" + Loader.folder + "/Ble/ble.txt", Loader.offline);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            version = new String(buffer.toByteArray());
            this.lblBleAppOnline.setText(version);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    private String getBleCoreVersion() {
        String version = null;
        try {
            int nRead;
            InputStream is = Utils.getInputStreamContent("/bin/" + Loader.folder + "/Ble/bleCore.txt", Loader.offline);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            version = new String(buffer.toByteArray());
            this.lblBleCoreOnline.setText(version);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    private boolean checkDisplayVersion() {
        if (!Utils.checkInternetConnection()) {
            JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.server.no_connection"), "Error", 0);
            return false;
        }
        String displayVersion = "";
        try {
            displayVersion = this.getSerialDisplayVersion();
        }
        catch (Exception e) {
            displayVersion = "";
        }
        DISPLAY_FAMILY = this.getDisplayFamily();
        String displayFilename = "display.txt";
        if (DISPLAY_FAMILY >= 2) {
            displayFilename = "displayV" + DISPLAY_FAMILY + ".txt";
        }
        int displayVersionNumber = Utils.cleanVersion(this.lblDisplayLocal.getText());
        if (DISPLAY_TYPE == 2 && displayVersionNumber >= 20000 && displayVersionNumber < 30000) {
            displayFilename = "displayV3.txt";
        } else if (DISPLAY_TYPE == 2 && displayVersionNumber >= 50000 && displayVersionNumber < 60000) {
            displayFilename = "displayV7.txt";
        }
        int curr = Utils.cleanVersion(displayVersion);
        if (curr > 0) {
            String latest = this.getDisplayVersion(displayFilename);
            int last = Utils.cleanVersion(latest);
            if (last < 0) {
                return false;
            }
            if (curr >= last) {
                JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.display.latest"), "Error", 0);
                return false;
            }
        }
        return true;
    }

    private void serialUpdateDisplay() {
        block14: {
            this.btnUpload.setEnabled(false);
            this.scanButton.setEnabled(false);
            this.menuItemRecoveryMotor.setEnabled(false);
            this.menuItemRecoveryDisplay.setEnabled(false);
            this.stopPinger();
            ++this.currentStep;
            this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_1.display"));
            this.overallProgressBar.setValue(this.currentStep);
            try {
                if (ON_BIOS) {
                    JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.update.turn_on_bike"), "Warning", 2);
                    this.startPinger();
                    this.btnUpload.setEnabled(true);
                    this.scanButton.setEnabled(true);
                    this.menuItemRecoveryMotor.setEnabled(true);
                    this.menuItemRecoveryMotor.setSelected(false);
                    this.menuItemRecoveryDisplay.setEnabled(true);
                    this.UPDATE_FINISHED_WITH_ERROR = true;
                    this.UPDATE_FINISHED_DISPLAY = true;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                DISPLAY_TYPE = this.getDisplayType();
            }
            catch (Exception e) {
                DISPLAY_TYPE = -1;
            }
            if (DISPLAY_TYPE < 1) {
                JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.display.no_update"), "Warning", 2);
                this.startPinger();
                this.btnUpload.setEnabled(true);
                this.scanButton.setEnabled(true);
                this.menuItemRecoveryMotor.setEnabled(true);
                this.menuItemRecoveryDisplay.setEnabled(true);
                this.menuItemRecoveryMotor.setSelected(false);
                this.UPDATE_FINISHED_DISPLAY = true;
                return;
            }
            if (this.menuItemRecoveryDisplay.isSelected()) {
                try {
                    Serial.sendWriteVarString("displayFamily", "" + DISPLAY_FAMILY);
                    DataPacket sp = Serial.getSerialResponse((byte)2, 200L);
                    if (sp == null) {
                        JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.display.family.error"), "Warning", 2);
                        this.startPinger();
                        this.btnUpload.setEnabled(true);
                        this.scanButton.setEnabled(true);
                        this.menuItemRecoveryMotor.setEnabled(true);
                        this.menuItemRecoveryDisplay.setEnabled(true);
                        this.UPDATE_FINISHED_WITH_ERROR = true;
                        this.UPDATE_FINISHED_DISPLAY = true;
                        return;
                    }
                    break block14;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.display.family.error"), "Warning", 2);
                    this.startPinger();
                    this.btnUpload.setEnabled(true);
                    this.scanButton.setEnabled(true);
                    this.menuItemRecoveryMotor.setEnabled(true);
                    this.menuItemRecoveryDisplay.setEnabled(true);
                    this.UPDATE_FINISHED_WITH_ERROR = true;
                    this.UPDATE_FINISHED_DISPLAY = true;
                    return;
                }
            }
            if (!this.checkDisplayVersion()) {
                this.UPDATE_FINISHED_DISPLAY = true;
                return;
            }
        }
        try {
            int PoliniBattery;
            if (DISPLAY_FAMILY < 2 && (PoliniBattery = this.getPoliniBattery()) == 3) {
                JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.display.family.battery"), "Warning", 2);
                this.UPDATE_FINISHED_DISPLAY = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.displayUpdateWorker = new SerialDisplayUpdater();
        this.displayUpdateWorker.execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendConsoleFrames(DisplayPacket dp, byte cmd) {
        int i = 0;
        DataPacket sp = null;
        try {
            while (true) {
                if (i >= dp.getFrameNumber()) {
                    return true;
                }
                Serial.writeBytes(dp.getFrame(i));
                sp = Serial.getSerialResponse(cmd, 25000L);
                if (sp == null) {
                    return false;
                }
                String r = new String(sp.data).trim();
                if (!r.equals("N")) throw new Exception("ERRORE RICEZIONE");
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkDisplayResponse(byte cmd, String value) {
        DataPacket sp;
        block3: {
            try {
                sp = Serial.getSerialResponse(cmd, 20000L);
                if (sp != null) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        String response = new String(sp.data).trim();
        return response.equals(value);
    }

    private void serialUpdateBle() {
        this.changeLogForm.dispose();
        this.btnUpload.setEnabled(false);
        this.scanButton.setEnabled(false);
        this.menuItemRecoveryMotor.setEnabled(false);
        this.menuItemRecoveryDisplay.setEnabled(false);
        this.stopPinger();
        ++this.currentStep;
        this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_1.ble"));
        this.overallProgressBar.setValue(this.currentStep);
        try {
            if (ON_BIOS) {
                JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.update.turn_on_bike"), "Warning", 2);
                this.startPinger();
                this.btnUpload.setEnabled(true);
                this.scanButton.setEnabled(true);
                this.menuItemRecoveryMotor.setEnabled(true);
                this.menuItemRecoveryMotor.setSelected(false);
                this.menuItemRecoveryDisplay.setEnabled(true);
                this.UPDATE_FINISHED_WITH_ERROR = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DISPLAY_TYPE = this.getDisplayType();
        }
        catch (Exception e) {
            DISPLAY_TYPE = -1;
        }
        if (DISPLAY_TYPE < 1) {
            JOptionPane.showMessageDialog(this, Loader.messageBundle.getString("loader.ble.no_update"), "Warning", 2);
            this.startPinger();
            this.btnUpload.setEnabled(true);
            this.scanButton.setEnabled(true);
            this.menuItemRecoveryMotor.setEnabled(true);
            this.menuItemRecoveryDisplay.setEnabled(true);
            this.menuItemRecoveryMotor.setSelected(false);
            return;
        }
        this.stopPinger();
        this.bleAppUpdateWorker = new SerialBleAppUpdater();
        this.bleAppUpdateWorker.execute();
    }

    private void serialUpdateBleCore() {
        this.changeLogForm.dispose();
        this.bleCoreUpdateWorker = new SerialBleCoreUpdater();
        this.bleCoreUpdateWorker.execute();
    }

    private void waitRestart() {
        long timeNow;
        long timeStart = System.currentTimeMillis();
        int MILLIS_TIMEOUT = 40000;
        this.setWaitingUploadBar();
        this.uploadProgressBar.setMaximum(40000);
        this.uploadProgressBar.setValue(0);
        this.uploadProgressBar.setMinimum(0);
        System.out.print("waiting restart board");
        while (timeStart + 40000L > (timeNow = System.currentTimeMillis())) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.print(".");
            this.uploadProgressBar.setValue((int)(timeNow - timeStart));
        }
        System.out.println();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.setDefaultUploadBar();
        this.uploadProgressBar.setMaximum(40000);
        this.uploadProgressBar.setValue(0);
    }

    private void setWaitingUploadBar() {
        this.uploadProgressBar.setString(Loader.messageBundle.getString("loader.step_5.ble.core"));
        this.uploadProgressBar.setUI(new BasicProgressBarUI(){

            @Override
            protected Color getSelectionBackground() {
                return Color.black;
            }

            @Override
            protected Color getSelectionForeground() {
                return Color.black;
            }
        });
        this.uploadProgressBar.setStringPainted(true);
        this.uploadProgressBar.setForeground(Color.yellow);
    }

    private void setDefaultUploadBar() {
        this.uploadProgressBar.setString("");
        this.uploadProgressBar.setStringPainted(false);
        this.uploadProgressBar.setForeground(new Color(0, 202, 231));
    }

    private int getPoliniBattery() throws Exception {
        String s = this.getVarString("PoliniBattery");
        if (s.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private int getDisplayFamily() {
        int displayFamily = -1;
        try {
            String s = this.getVarString("displayFamily");
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            displayFamily = -1;
            return displayFamily;
        }
    }

    private String createTitle() {
        String title = "Polini Updater";
        if (!Loader.folder.equals("FW")) {
            title = String.valueOf(title) + " " + Loader.folder;
        }
        if (Loader.offline) {
            title = String.valueOf(title) + " OFFLINE";
        }
        title = String.valueOf(title) + " [6.14.19]";
        return title;
    }

    private int getWindowsVersion() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            float version = Float.parseFloat(System.getProperty("os.version"));
            if (version == 6.2f || version == 6.3f) {
                return 8;
            }
            if (version == 10.0f) {
                return 10;
            }
            return -1;
        }
        return 0;
    }

    private String getFWVersion() throws Exception {
        return this.getVarString("FWVer");
    }

    private String getVarString(String varName) throws Exception {
        if (!Serial.sendReadVarString(varName)) {
            Serial.closeConnection();
            throw new Exception("failed to send read var string: " + varName);
        }
        DataPacket sp = null;
        sp = Serial.getSerialResponse((byte)22, 200L);
        if (sp != null) {
            String tmp = new String(sp.data);
            tmp = tmp.replace(varName, "").trim().toUpperCase();
            return tmp;
        }
        return "";
    }

    private int getDisplayType() throws Exception {
        String s = this.getVarString("PoliniDisplay");
        if (s.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private String getSerialDisplayVersion() throws Exception {
        return this.getVarString("displayFw");
    }

    private int getCdBtEnabled() throws Exception {
        return Integer.parseInt(this.getVarString("cd.btEnabled"));
    }

    private String getBtVersion() throws Exception {
        return this.getVarString("btVersion");
    }

    private String getBtFwVersion() throws Exception {
        return this.getVarString("btFwVer");
    }

    private String getOdometerM() throws Exception {
        return this.getVarString("odometer[m]");
    }

    private String getGwBatteryReady() throws Exception {
        return this.getVarString("gwBatteryReady");
    }

    public class SerialBleAppUpdater
    extends SwingWorker<Void, Void> {
        private void stopUpdate(String stopCause) {
            try {
                LoaderForm.this.lblMessage.setText(stopCause);
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LoaderForm.this.btnUpload.setEnabled(true);
            LoaderForm.this.scanButton.setEnabled(true);
            LoaderForm.this.menuItemRecoveryMotor.setEnabled(true);
            LoaderForm.this.menuItemRecoveryDisplay.setEnabled(true);
            if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                LoaderForm.this.configureSteps();
            }
            JOptionPane.showMessageDialog(null, String.valueOf(stopCause) + Loader.messageBundle.getString("loader.ble.restart"), "Error", 0);
            LoaderForm.this.startPinger();
            LoaderForm.this.UPDATE_FINISHED_WITH_ERROR = true;
            LoaderForm.this.UPDATE_FINISHED_BLE_APP = true;
            this.cancel(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Void doInBackground() throws Exception {
            Thread.currentThread().setName(this.getClass().getName());
            LoaderForm.this.uploadProgressBar.setValue(0);
            LoaderForm loaderForm = LoaderForm.this;
            loaderForm.currentStep = loaderForm.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_2.ble"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            InputStream binStream = null;
            try {
                String remoteUrl = "/bin/" + Loader.folder + "/Ble/ble.uwc";
                binStream = Utils.getInputStreamContent(remoteUrl, Loader.offline);
                if (binStream == null) {
                    throw new IOException("bin not found");
                }
            }
            catch (IOException ioe) {
                this.stopUpdate(Loader.messageBundle.getString("loader.ble.no_firmware"));
                return null;
            }
            LoaderForm loaderForm2 = LoaderForm.this;
            loaderForm2.currentStep = loaderForm2.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_3.ble"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            String[] packets = null;
            try {
                StringBuilder sb = new StringBuilder();
                while (true) {
                    int byteRead;
                    if ((byteRead = binStream.read()) == -1) {
                        packets = Utils.splitString(sb.toString(), 100);
                        break;
                    }
                    sb.append(String.format("%02x", byteRead & 0xFF));
                }
            }
            catch (Exception e) {
                this.stopUpdate(Loader.messageBundle.getString("loader.ble.error_prepare"));
                return null;
            }
            LoaderForm.this.uploadProgressBar.setMaximum(packets.length + 2);
            LoaderForm loaderForm3 = LoaderForm.this;
            loaderForm3.currentStep = loaderForm3.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_4.ble"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            try {
                block24: {
                    LoaderForm.this.stopPinger();
                    Thread.sleep(500L);
                    if (!Serial.sendWriteVarString("mode_BT", "1")) {
                        this.stopUpdate(String.valueOf(Loader.messageBundle.getString("loader.ble.error_connection")) + " 1");
                        return null;
                    }
                    if (!Serial.sendWriteVarString("USB_Trough_BT", "1")) {
                        this.stopUpdate(String.valueOf(Loader.messageBundle.getString("loader.ble.error_connection")) + " 2");
                        return null;
                    }
                    Thread.sleep(100L);
                    try {
                        Serial.closeConnection();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Thread.sleep(5000L);
                    int serialCount = 0;
                    do {
                        if (Serial.isOpened()) {
                            Thread.sleep(200L);
                            if (!Serial.sendBleCommand("at\r\n")) {
                                this.stopUpdate(String.valueOf(Loader.messageBundle.getString("loader.ble.error_connection")) + " 4");
                                return null;
                            }
                            break block24;
                        }
                        Thread.sleep(1000L);
                        try {
                            Serial.openConnection(LoaderForm.this.lblSerialPort.getText(), 115200);
                        }
                        catch (Exception ssss) {
                            ssss.printStackTrace();
                        }
                    } while (++serialCount <= 10);
                    this.stopUpdate(String.valueOf(Loader.messageBundle.getString("loader.ble.error_connection")) + " 3");
                    return null;
                }
                LoaderForm loaderForm4 = LoaderForm.this;
                loaderForm4.currentStep = loaderForm4.currentStep + 1;
                LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_5.ble"));
                LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                if (!Serial.sendBleCommand("at&f *\r\n")) {
                    this.stopUpdate(Loader.messageBundle.getString("loader.ble.error_erase"));
                    return null;
                }
                LoaderForm loaderForm5 = LoaderForm.this;
                loaderForm5.currentStep = loaderForm5.currentStep + 1;
                LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_6.ble"));
                LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                LoaderForm.this.uploadProgressBar.setString(Loader.messageBundle.getString("loader.ble_progress"));
                int value = 0;
                if (!Serial.sendBleCommand("at+fow \"$autorun$\"\r\n")) {
                    this.stopUpdate(Loader.messageBundle.getString("loader.ble.error_upload_open"));
                    return null;
                }
                LoaderForm.this.uploadProgressBar.setValue(++value);
                int i = 0;
                while (true) {
                    if (i >= packets.length) {
                        if (Serial.sendBleCommand("at+fcl\r\n")) break;
                        this.stopUpdate(Loader.messageBundle.getString("loader.ble.error_upload_close"));
                        return null;
                    }
                    if (!Serial.sendBleCommand("at+fwrh \"" + packets[i] + "\"\r\n")) {
                        this.stopUpdate(Loader.messageBundle.getString("loader.ble.error_upload_upload"));
                        return null;
                    }
                    LoaderForm.this.uploadProgressBar.setValue(++value);
                    ++i;
                }
                LoaderForm.this.uploadProgressBar.setValue(++value);
            }
            catch (Exception e) {
                this.stopUpdate(String.valueOf(Loader.messageBundle.getString("loader.ble.error_connection")) + " 5");
                return null;
            }
            Thread.sleep(100L);
            LoaderForm.this.UPDATE_FINISHED_BLE_APP = true;
            return null;
        }
    }

    public class SerialBleCoreUpdater
    extends SwingWorker<Void, Void> {
        private void stopUpdate(String stopCause) {
            try {
                LoaderForm.this.lblMessage.setText(stopCause);
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LoaderForm.this.btnUpload.setEnabled(true);
            LoaderForm.this.scanButton.setEnabled(true);
            LoaderForm.this.menuItemRecoveryMotor.setEnabled(true);
            LoaderForm.this.menuItemRecoveryDisplay.setEnabled(true);
            if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                LoaderForm.this.configureSteps();
            }
            JOptionPane.showMessageDialog(null, String.valueOf(stopCause) + Loader.messageBundle.getString("loader.ble.restart"), "Error", 0);
            LoaderForm.this.startPinger();
            LoaderForm.this.UPDATE_FINISHED_WITH_ERROR = true;
            LoaderForm.this.UPDATE_FINISHED_BLE_CORE = true;
            this.cancel(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            Thread.currentThread().setName(this.getClass().getName());
            String userHome = "c:\\tmp";
            File directory = new File(String.valueOf(userHome) + "/Polini");
            if (!directory.exists()) {
                directory.mkdirs();
            }
            String exeFilename = "bleCoreUpdater.exe";
            String binFilename = "bleCore.uwf";
            String localBaseUrl = directory.getAbsolutePath();
            if (!(localBaseUrl = localBaseUrl.replace("\\", "/")).endsWith("/")) {
                localBaseUrl = String.valueOf(localBaseUrl) + "/";
            }
            String remoteBaseUrl = "/bin/" + Loader.folder + "/Ble/";
            LoaderForm loaderForm = LoaderForm.this;
            loaderForm.currentStep = loaderForm.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_1.ble.core"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            InputStream prg = Utils.getInputStreamContent(String.valueOf(remoteBaseUrl) + exeFilename, Loader.offline);
            File targetExeFile = new File(String.valueOf(localBaseUrl) + exeFilename);
            Files.copy(prg, targetExeFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            prg.close();
            prg = null;
            LoaderForm loaderForm2 = LoaderForm.this;
            loaderForm2.currentStep = loaderForm2.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_2.ble.core"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            InputStream bin = Utils.getInputStreamContent(String.valueOf(remoteBaseUrl) + binFilename, Loader.offline);
            File targetBinFile = new File(String.valueOf(localBaseUrl) + binFilename);
            Files.copy(bin, targetBinFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            bin.close();
            bin = null;
            LoaderForm loaderForm3 = LoaderForm.this;
            loaderForm3.currentStep = loaderForm3.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_3.ble.core"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            LoaderForm.this.stopPinger();
            Thread.sleep(500L);
            Serial.sendWriteVarString("cd.btEnabled", "1");
            Thread.sleep(1500L);
            Serial.sendWriteVarString("mode_BT", "1");
            Thread.sleep(100L);
            Serial.sendWriteVarString("USB_Trough_BT", "1");
            Thread.sleep(100L);
            String com = LoaderForm.this.lblSerialPort.getText().toUpperCase();
            if (com.startsWith("COM")) {
                com = com.substring(3);
            }
            Path currentRelativePath = Paths.get(localBaseUrl, new String[0]);
            String s = currentRelativePath.toAbsolutePath().toString();
            LoaderForm loaderForm4 = LoaderForm.this;
            loaderForm4.currentStep = loaderForm4.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_4.ble.core"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            Thread.sleep(5000L);
            int r = Utils.executeProcessWindows(new String[]{"cmd.exe", "/c", String.valueOf(s) + "\\" + exeFilename, "TGT=BL65X", "UWF=" + s + "\\" + binFilename, "COM=" + com, "ACCEPT", "AUTOMODE", "AUTOEXIT"});
            File f = new File(String.valueOf(s) + "\\" + binFilename);
            f.delete();
            f = new File(String.valueOf(s) + "\\" + exeFilename);
            f.delete();
            f = new File(String.valueOf(s) + "\\");
            f.delete();
            if (r != 0) {
                this.stopUpdate("ERROR CODE = " + r + "\n");
                return null;
            }
            Thread.sleep(500L);
            LoaderForm loaderForm5 = LoaderForm.this;
            loaderForm5.currentStep = loaderForm5.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_5.ble.core"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            LoaderForm.this.stopPinger();
            Thread.sleep(5000L);
            Thread.sleep(500L);
            LoaderForm.this.waitRestart();
            Thread.sleep(1000L);
            try {
                Serial.closeConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
            firmwareDetected = false;
            LoaderForm.this.startPinger();
            LoaderForm.this.firmwareRetry = 60;
            while (!firmwareDetected) {
                Thread.sleep(1000L);
                LoaderForm loaderForm6 = LoaderForm.this;
                loaderForm6.firmwareRetry = loaderForm6.firmwareRetry - 1;
                if (LoaderForm.this.firmwareRetry > 0) continue;
                this.stopUpdate(Loader.messageBundle.getString("loader.update.bike"));
                return null;
            }
            LoaderForm.this.UPDATE_FINISHED_BLE_CORE = true;
            return null;
        }
    }

    private class SerialDatabaseStringWriter
    extends SwingWorker<Void, Void> {
        private InputStream parameters;

        private void stopUpdate(String stopCause) {
            LoaderForm.this.lblMessage.setText(stopCause);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LoaderForm.this.btnUpload.setEnabled(true);
            LoaderForm.this.scanButton.setEnabled(true);
            LoaderForm.this.menuItemRecoveryMotor.setEnabled(true);
            LoaderForm.this.menuItemRecoveryDisplay.setEnabled(true);
            if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                LoaderForm.this.configureSteps();
            }
            JOptionPane.showMessageDialog(null, stopCause, "Error", 0);
            LoaderForm.this.startPinger();
            LoaderForm.this.UPDATE_FINISHED_WITH_ERROR = true;
            LoaderForm.this.UPDATE_FINISHED_MOTOR = true;
            this.cancel(true);
        }

        public SerialDatabaseStringWriter(InputStream parameters) {
            this.parameters = parameters;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Void doInBackground() {
            Thread.currentThread().setName(this.getClass().getName());
            ValuesList vl = new ValuesList();
            String errorMessage = null;
            try {
                LoaderForm.this.btnUpload.setEnabled(false);
                LoaderForm.this.scanButton.setEnabled(false);
                LoaderForm.this.menuItemRecoveryMotor.setEnabled(false);
                LoaderForm.this.menuItemRecoveryDisplay.setEnabled(false);
                boolean md5 = vl.loadFromCryptedStream(this.parameters);
                this.parameters.close();
                this.parameters = null;
                if (!md5) {
                    errorMessage = Loader.messageBundle.getString("loader.update.md5");
                    LoaderForm.this.btnUpload.setEnabled(true);
                    LoaderForm.this.scanButton.setEnabled(true);
                    LoaderForm.this.menuItemRecoveryMotor.setEnabled(true);
                    LoaderForm.this.menuItemRecoveryDisplay.setEnabled(true);
                    if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                        LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                        LoaderForm.this.configureSteps();
                    }
                    LoaderForm.this.startPinger();
                    this.cancel(true);
                    return null;
                }
            }
            catch (Exception ef) {
                if (errorMessage == null) {
                    errorMessage = Loader.messageBundle.getString("loader.update.error_file");
                }
                this.stopUpdate(errorMessage);
            }
            try {
                LoaderForm.this.uploadProgressBar.setMinimum(0);
                LoaderForm.this.uploadProgressBar.setMaximum(vl.getValuesSize() - 1);
                int i = 0;
                while (i < 3) {
                    Serial.sendOnDb(1);
                    Thread.sleep(100L);
                    ++i;
                }
                LoaderForm loaderForm = LoaderForm.this;
                loaderForm.currentStep = loaderForm.currentStep + 1;
                LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_6"));
                i = 0;
                while (i < vl.getValuesSize()) {
                    if (!Serial.sendWriteVarString(vl.getValueAt(i).getName(), vl.getValueAt(i).getValue())) {
                        this.stopUpdate(Loader.messageBundle.getString("loader.update.file_upload_error"));
                    }
                    DataPacket sp = Serial.getSerialResponse((byte)2, 200L);
                    LoaderForm.this.uploadProgressBar.setValue(i);
                    Thread.sleep(10L);
                    ++i;
                }
                if (LoaderForm.this.odometer != null) {
                    Serial.sendWriteVarString(LoaderForm.this.odometer.getName(), LoaderForm.this.odometer.getValue());
                    Serial.getSerialResponse((byte)2, 200L);
                    Serial.sendWriteVarString("odo_pas_0[m]", "0");
                    Serial.getSerialResponse((byte)2, 200L);
                    Serial.sendWriteVarString("odo_pas_1[m]", "0");
                    Serial.getSerialResponse((byte)2, 200L);
                    Serial.sendWriteVarString("odo_pas_2[m]", "0");
                    Serial.getSerialResponse((byte)2, 200L);
                    Serial.sendWriteVarString("odo_pas_3[m]", "0");
                    Serial.getSerialResponse((byte)2, 200L);
                    Serial.sendWriteVarString("odo_pas_4[m]", "0");
                    Serial.getSerialResponse((byte)2, 200L);
                    Serial.sendWriteVarString("odo_pas_5[m]", "0");
                    Serial.getSerialResponse((byte)2, 200L);
                }
                LoaderForm.this.odometer = null;
                LoaderForm loaderForm2 = LoaderForm.this;
                loaderForm2.currentStep = loaderForm2.currentStep + 1;
                LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.update.upload_parameters_complete"));
                Thread.sleep(25L);
                firmwareDetected = false;
                ON_BIOS = false;
                LoaderForm.this.startPinger();
                Thread.sleep(100L);
                if (!LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                    LoaderForm.this.UPDATE_FINISHED_MOTOR = true;
                    return null;
                }
                LoaderForm.this.firmwareRetry = 300;
                while (!firmwareDetected) {
                    Thread.sleep(100L);
                    LoaderForm loaderForm3 = LoaderForm.this;
                    loaderForm3.firmwareRetry = loaderForm3.firmwareRetry - 1;
                    if (LoaderForm.this.firmwareRetry > 0) continue;
                    this.stopUpdate(Loader.messageBundle.getString("loader.update.bike"));
                    return null;
                }
                int count = 50;
                while (count > 0) {
                    Thread.sleep(100L);
                    if (fwVer.startsWith("EP3") || fwVer.startsWith("RM")) break;
                    --count;
                }
                if (count <= 0) {
                    this.stopUpdate(Loader.messageBundle.getString("loader.update.bike"));
                    return null;
                }
                JOptionPane.showMessageDialog(null, Loader.messageBundle.getString("loader.update.success.recovery"), "Update status", 1);
                LoaderForm.this.btnUpload.setEnabled(false);
                LoaderForm.this.scanButton.setEnabled(false);
                LoaderForm.this.menuItemRecoveryMotor.setEnabled(false);
                LoaderForm.this.menuItemRecoveryDisplay.setEnabled(false);
                LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                LoaderForm.this.configureSteps();
                LoaderForm.this.serialMotorUpdate();
                return null;
            }
            catch (Exception e) {
                this.stopUpdate(Loader.messageBundle.getString("loader.update.file_upload_error"));
            }
            return null;
        }
    }

    public class SerialDisplayUpdater
    extends SwingWorker<Void, Void> {
        private void stopUpdate(String stopCause) {
            try {
                LoaderForm.this.lblMessage.setText(stopCause);
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LoaderForm.this.btnUpload.setEnabled(true);
            LoaderForm.this.scanButton.setEnabled(true);
            LoaderForm.this.menuItemRecoveryMotor.setEnabled(true);
            LoaderForm.this.menuItemRecoveryDisplay.setEnabled(true);
            if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                LoaderForm.this.configureSteps();
            }
            LoaderForm.this.startPinger();
            LoaderForm.this.UPDATE_FINISHED_WITH_ERROR = true;
            LoaderForm.this.UPDATE_FINISHED_DISPLAY = true;
            this.cancel(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            DataPacket sp;
            boolean eraseError;
            int binSize;
            int dataSize;
            ArrayList<DisplayPacket> packetList;
            block38: {
                int page;
                block37: {
                    int PoliniBattery;
                    Thread.currentThread().setName(this.getClass().getName());
                    Thread.currentThread().setPriority(10);
                    boolean first = true;
                    LoaderForm.this.uploadProgressBar.setValue(0);
                    packetList = new ArrayList<DisplayPacket>();
                    LoaderForm loaderForm = LoaderForm.this;
                    loaderForm.currentStep = loaderForm.currentStep + 1;
                    LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_2.display"));
                    LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                    dataSize = 512;
                    InputStream binStream = null;
                    binSize = 0;
                    try {
                        int fileReadCount;
                        String tmp;
                        int stringVal;
                        String displayFilename = "display.bin";
                        if (DISPLAY_FAMILY >= 2) {
                            displayFilename = "displayV" + DISPLAY_FAMILY + ".bin";
                        }
                        int displayVersionNumber = Utils.cleanVersion(LoaderForm.this.lblDisplayLocal.getText());
                        if (DISPLAY_TYPE == 2 && displayVersionNumber >= 20000 && displayVersionNumber < 30000) {
                            displayFilename = "displayV3.bin";
                        } else if (DISPLAY_TYPE == 2 && displayVersionNumber >= 50000 && displayVersionNumber < 60000) {
                            displayFilename = "displayV7.bin";
                        }
                        String remoteUrl = "/bin/" + Loader.folder + "/DisplayCD/" + displayFilename;
                        binStream = Utils.getInputStreamContent(remoteUrl, Loader.offline);
                        if (binStream == null) {
                            throw new IOException("bin not found");
                        }
                        binSize = binStream.available();
                        byte[] data = new byte[dataSize];
                        byte packetNumber = 0;
                        short frameLength = Utils.cleanVersion(LoaderForm.this.lblDisplayLocal.getText()) >= 50000 ? ((stringVal = Utils.cleanVersion(tmp = LoaderForm.this.lblMotorLocal.getText())) >= 30000 ? (short)248 : 32) : (short)32;
                        do {
                            fileReadCount = 0;
                            int i = 0;
                            while (i < data.length) {
                                try {
                                    int byteRead = binStream.read();
                                    if (byteRead == -1) break;
                                    data[i] = (byte)byteRead;
                                    ++fileReadCount;
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                                ++i;
                            }
                            if (fileReadCount != dataSize) {
                                i = fileReadCount;
                                while (i < dataSize) {
                                    data[i] = 0;
                                    ++i;
                                }
                            }
                            if ((packetNumber = (byte)((byte)(packetNumber + 1))) > 255) {
                                packetNumber = (byte)(packetNumber - 256);
                            }
                            byte invertedPacketNumber = (byte)(255 - packetNumber);
                            packetList.add(new DisplayPacket(67, Commands.createUploadRunPacket(data, packetNumber, invertedPacketNumber), frameLength));
                        } while (dataSize == fileReadCount);
                    }
                    catch (IOException ioe) {
                        this.stopUpdate(Loader.messageBundle.getString("loader.display.no_firmware"));
                        return null;
                    }
                    Locale.getDefault();
                    String contentUrl = "/bin/" + Loader.folder + "/DisplayCD/CHANGELOG/changelog_" + Locale.forLanguageTag(Locale.getDefault().toLanguageTag()) + ".txt";
                    String defaultUrl = "/bin/" + Loader.folder + "/DisplayCD/CHANGELOG/changelog.txt";
                    int displayVersionNumber = Utils.cleanVersion(LoaderForm.this.lblDisplayLocal.getText());
                    if (DISPLAY_TYPE == 2 && displayVersionNumber >= 20000 && displayVersionNumber < 30000) {
                        contentUrl = "/bin/" + Loader.folder + "/DisplayCD/CHANGELOG/changelogV3_" + Locale.forLanguageTag(Locale.getDefault().toLanguageTag()) + ".txt";
                        defaultUrl = "/bin/" + Loader.folder + "/DisplayCD/CHANGELOG/changelogV3.txt";
                    } else if (DISPLAY_TYPE == 2 && displayVersionNumber >= 50000 && displayVersionNumber < 60000) {
                        contentUrl = "/bin/" + Loader.folder + "/DisplayCD/CHANGELOG/changelogV7_" + Locale.forLanguageTag(Locale.getDefault().toLanguageTag()) + ".txt";
                        defaultUrl = "/bin/" + Loader.folder + "/DisplayCD/CHANGELOG/changelogV7.txt";
                    } else if (DISPLAY_FAMILY >= 2) {
                        contentUrl = "/bin/" + Loader.folder + "/DisplayCD/CHANGELOG/changelogV" + DISPLAY_FAMILY + "_" + Locale.forLanguageTag(Locale.getDefault().toLanguageTag()) + ".txt";
                        defaultUrl = "/bin/" + Loader.folder + "/DisplayCD/CHANGELOG/changelogV" + DISPLAY_FAMILY + ".txt";
                    }
                    LoaderForm.this.changeLogForm.showContent(contentUrl, defaultUrl);
                    LoaderForm loaderForm2 = LoaderForm.this;
                    loaderForm2.currentStep = loaderForm2.currentStep + 1;
                    LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_3.display"));
                    LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                    if (DISPLAY_FAMILY >= 2 && (PoliniBattery = LoaderForm.this.getPoliniBattery()) == 3) {
                        int waitTime = 0;
                        while (waitTime < 10000) {
                            try {
                                String tmp = LoaderForm.this.getGwBatteryReady();
                                int sm = Integer.parseInt(tmp);
                                if (sm != 0) break;
                                Serial.sendWriteVarString("gwSendDummy", "1");
                                Serial.getSerialResponse((byte)2, 200L);
                                waitTime += 100;
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                waitTime += 100;
                                Thread.sleep(100L);
                            }
                        }
                    }
                    Serial.sendDisplayReboot();
                    LoaderForm.this.uploadProgressBar.setString(Loader.messageBundle.getString("loader.display.erase"));
                    page = -1;
                    eraseError = false;
                    int count = 10;
                    while (true) {
                        if (--count < 0) {
                            this.stopUpdate(Loader.messageBundle.getString("loader.display.erase_error"));
                            return null;
                        }
                        sp = Serial.getSerialResponse((byte)64, 6000L);
                        if (sp == null) break block37;
                        count = 10;
                        String res = new String(sp.data);
                        res = res.trim();
                        page = Integer.parseInt(res);
                        if (first) {
                            LoaderForm.this.uploadProgressBar.setMaximum(page);
                            first = false;
                            continue;
                        }
                        LoaderForm.this.uploadProgressBar.setValue(++page);
                        if (page >= LoaderForm.this.uploadProgressBar.getMaximum()) break;
                    }
                    break block38;
                }
                if (LoaderForm.this.uploadProgressBar.getMaximum() <= 0 || page < LoaderForm.this.uploadProgressBar.getMaximum()) {
                    eraseError = true;
                }
            }
            if (eraseError) {
                this.stopUpdate(Loader.messageBundle.getString("loader.display.erase_error"));
                return null;
            }
            Thread.sleep(300L);
            LoaderForm loaderForm = LoaderForm.this;
            loaderForm.currentStep = loaderForm.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_4.display"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            Serial.sendDisplayUpdateReady();
            sp = Serial.getSerialResponse((byte)65, 15000L);
            if (sp == null) {
                this.stopUpdate(Loader.messageBundle.getString("loader.display.prepare_error_1"));
                return null;
            }
            String res = new String(sp.data);
            if (!(res = res.trim()).equals("C")) {
                this.stopUpdate(Loader.messageBundle.getString("loader.display.prepare_error_2"));
                return null;
            }
            Thread.sleep(500L);
            DisplayPacket dp = new DisplayPacket(66, Commands.createUploadStartPacket(dataSize, binSize), 32);
            if (!LoaderForm.this.sendConsoleFrames(dp, (byte)66)) {
                this.stopUpdate(Loader.messageBundle.getString("loader.display.prepare_error_3"));
                return null;
            }
            if (!LoaderForm.this.checkDisplayResponse((byte)66, "6")) {
                this.stopUpdate(Loader.messageBundle.getString("loader.display.prepare_error_4"));
                return null;
            }
            if (!LoaderForm.this.checkDisplayResponse((byte)66, "C")) {
                this.stopUpdate(Loader.messageBundle.getString("loader.display.prepare_error_5"));
                return null;
            }
            Thread.sleep(100L);
            LoaderForm.this.uploadProgressBar.setMaximum(packetList.size());
            LoaderForm.this.uploadProgressBar.setValue(0);
            LoaderForm loaderForm3 = LoaderForm.this;
            loaderForm3.currentStep = loaderForm3.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_5.display"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            int i = 0;
            while (i < packetList.size()) {
                Serial.rxIn = 0;
                Serial.rxOut = 0;
                if (!LoaderForm.this.sendConsoleFrames((DisplayPacket)packetList.get(i), (byte)67)) {
                    this.stopUpdate(Loader.messageBundle.getString("loader.display.upload_error"));
                    return null;
                }
                if (!LoaderForm.this.checkDisplayResponse((byte)67, "6")) {
                    this.stopUpdate(Loader.messageBundle.getString("loader.display.upload_error"));
                    return null;
                }
                LoaderForm.this.uploadProgressBar.setValue(i + 1);
                ++i;
            }
            Serial.rxIn = 0;
            Serial.rxOut = 0;
            Serial.sendDisplayUpdateEOT();
            LoaderForm loaderForm4 = LoaderForm.this;
            loaderForm4.currentStep = loaderForm4.currentStep + 1;
            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_6.display"));
            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
            Serial.rxIn = 0;
            Serial.rxOut = 0;
            Serial.sendDisplayUdpateEnd();
            if (!LoaderForm.this.checkDisplayResponse((byte)70, "END")) {
                this.stopUpdate(Loader.messageBundle.getString("loader.display.restart_error"));
                return null;
            }
            Thread.sleep(100L);
            LoaderForm.this.startPinger();
            LoaderForm.this.UPDATE_FINISHED_DISPLAY = true;
            return null;
        }
    }

    private class SerialHardwarePinger
    extends SwingWorker<Void, Void> {
        private SerialHardwarePinger() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            Thread.currentThread().setName(this.getClass().getName());
            LoaderForm.this.overallProgressBar.setStringPainted(false);
            LoaderForm.this.overallProgressBar.setString("");
            LoaderForm.this.uploadProgressBar.setStringPainted(false);
            LoaderForm.this.uploadProgressBar.setString("");
            ON_BIOS = false;
            firmwareDetected = false;
            int cicleCounter = 0;
            block8: while (true) {
                if (!ENABLE_PING) {
                    while (!this.cancel(true)) {
                        Thread.sleep(10L);
                    }
                    return null;
                }
                try {
                    String tmp;
                    boolean isDisplayUpdatable;
                    Thread.sleep(100L);
                    if (!Serial.isOpened()) {
                        ON_BIOS = false;
                        firmwareDetected = false;
                        int i = 0;
                        while (true) {
                            if (i >= SerialPortList.getPortNames().length) continue block8;
                            if (SerialPortList.getPortNames()[i].equalsIgnoreCase(LoaderForm.this.lblSerialPort.getText())) {
                                try {
                                    Serial.openConnection(LoaderForm.this.lblSerialPort.getText(), 115200);
                                }
                                catch (Exception ex) {
                                    LoaderForm.this.lblMotorLocal.setText("");
                                    LoaderForm.this.lblDisplayLocal.setText("");
                                    LoaderForm.this.lblBleCoreLocal.setText("");
                                    LoaderForm.this.lblBleAppLocal.setText("");
                                    Serial.closeConnection();
                                }
                                continue block8;
                            }
                            ++i;
                        }
                    }
                    DataPacket sp = null;
                    Serial.rxIn = 0;
                    Serial.rxOut = 0;
                    try {
                        fwVer = LoaderForm.this.getFWVersion();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (!Serial.sendReadVarString("motorType")) {
                        Serial.closeConnection();
                        continue;
                    }
                    sp = null;
                    sp = Serial.getSerialResponse((byte)22, 200L);
                    if (sp != null) {
                        String tmp2 = new String(sp.data);
                        tmp2 = tmp2.replace("motorType", "").trim().toUpperCase();
                        MOTOR_TYPE = Integer.parseInt(tmp2);
                    }
                    sp = null;
                    if (!Serial.sendReadVarString("PoliniDisplay")) {
                        Serial.closeConnection();
                        continue;
                    }
                    sp = Serial.getSerialResponse((byte)22, 200L);
                    if (sp != null) {
                        String tmp3 = new String(sp.data);
                        tmp3 = tmp3.replace("PoliniDisplay", "").trim().toUpperCase();
                        DISPLAY_TYPE = Integer.parseInt(tmp3);
                    }
                    if (DISPLAY_TYPE < 0) {
                        DISPLAY_TYPE = 0;
                    }
                    if (LoaderForm.this.ON_UPDATE) {
                        firmwareDetected = fwVer != null;
                        if (!firmwareDetected) continue;
                        ON_BIOS = fwVer.toUpperCase().contains("BIOS");
                        continue;
                    }
                    int poliniBattery = LoaderForm.this.getPoliniBattery();
                    boolean bl = isDisplayUpdatable = DISPLAY_TYPE > 0 && (poliniBattery != 3 || DISPLAY_FAMILY >= 2);
                    if (fwVer == null) {
                        firmwareDetected = false;
                        LoaderForm.this.lblMotorLocal.setText("");
                        LoaderForm.this.lblDisplayLocal.setText("");
                        LoaderForm.this.lblBleCoreLocal.setText("");
                        LoaderForm.this.lblBleAppLocal.setText("");
                        LoaderForm.this.btnUpload.setEnabled(false);
                        Serial.closeConnection();
                        continue;
                    }
                    boolean enBtn = true;
                    firmwareDetected = true;
                    ON_BIOS = fwVer.toUpperCase().contains("BIOS");
                    if (fwVer.toUpperCase().startsWith("EP3") || fwVer.toUpperCase().startsWith("RM") || fwVer.toUpperCase().startsWith("MTI")) {
                        tmp = null;
                        tmp = fwVer.substring(fwVer.indexOf("-") + 1);
                        FW_VER_BOARD = Utils.cleanVersion(tmp);
                        LoaderForm.this.lblMotorLocal.setText(tmp);
                        String boardType = "";
                        LoaderForm.this.menuItemRecoveryDisplay.setVisible(isDisplayUpdatable);
                        LoaderForm.this.UPDATE_DISPLAY = isDisplayUpdatable;
                        if (FW_VER_BOARD >= 40000) {
                            boardType = "MRC2_";
                            if (DISPLAY_TYPE != 1) {
                                LoaderForm.this.menuOptions.setVisible(true);
                            }
                            LoaderForm.this.menuItemUpgrade.setVisible(DISPLAY_TYPE == 0 && FW_VER_BOARD >= 46502);
                            LoaderForm.this.menuItemDowngrade.setVisible(DISPLAY_TYPE == 2 && FW_VER_BOARD >= 46502);
                            LoaderForm.this.menuItemRecoveryBle.setVisible(DISPLAY_TYPE == 1);
                        } else if (FW_VER_BOARD >= 30000) {
                            LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.passIcon);
                            LoaderForm.this.lblDisplay.setVisible(false);
                            LoaderForm.this.lblDisplayLocal.setVisible(false);
                            LoaderForm.this.lblDisplayOnline.setVisible(false);
                            LoaderForm.this.lblDisplayStatus.setVisible(false);
                            LoaderForm.this.lblBleCore.setVisible(false);
                            LoaderForm.this.lblBleCoreLocal.setVisible(false);
                            LoaderForm.this.lblBleCoreOnline.setVisible(false);
                            LoaderForm.this.lblBleCoreStatus.setVisible(false);
                            LoaderForm.this.lblBleApp.setVisible(false);
                            LoaderForm.this.lblBleAppLocal.setVisible(false);
                            LoaderForm.this.lblBleAppOnline.setVisible(false);
                            LoaderForm.this.lblBleAppStatus.setVisible(false);
                            JLabel label = new JLabel();
                            Font font = label.getFont();
                            StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
                            style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
                            style.append("font-size:" + font.getSize() + "pt;");
                            String message = Loader.messageBundle.getString("loader.update.3XX");
                            JEditorPane ep = new JEditorPane("text/html", "<html><body style=\"" + style + "\">" + message.replace("\n", "<br/>") + "</body></html>");
                            ep.addHyperlinkListener(new HyperlinkListener(){

                                @Override
                                public void hyperlinkUpdate(HyperlinkEvent e) {
                                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                        try {
                                            Desktop.getDesktop().browse(e.getURL().toURI());
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                            ep.setEditable(false);
                            ep.setBackground(label.getBackground());
                            JOptionPane.showMessageDialog(null, ep);
                            System.exit(0);
                        } else {
                            if (DISPLAY_TYPE != 1) {
                                LoaderForm.this.menuOptions.setVisible(true);
                            }
                            LoaderForm.this.menuItemUpgrade.setVisible(DISPLAY_TYPE == 0 && FW_VER_BOARD >= 27700);
                            LoaderForm.this.menuItemDowngrade.setVisible(DISPLAY_TYPE == 2 && FW_VER_BOARD >= 27700);
                            LoaderForm.this.menuItemRecoveryDisplay.setVisible(isDisplayUpdatable);
                            LoaderForm.this.UPDATE_DISPLAY = isDisplayUpdatable;
                            LoaderForm.this.menuItemRecoveryBle.setVisible(false);
                            boardType = "MRC1_";
                        }
                        if (poliniBattery == 1 && this.canSwitchFromUartToCAN(LoaderForm.this.lblMotorLocal.getText()) && DISPLAY_FAMILY != -1 && (DISPLAY_FAMILY != 1 || DISPLAY_TYPE != 1 && DISPLAY_TYPE != 2 || Utils.cleanVersion(LoaderForm.this.lblDisplayLocal.getText()) >= Utils.cleanVersion(LoaderForm.this.lblDisplayOnline.getText()))) {
                            LoaderForm.this.menuOptions.setVisible(true);
                            LoaderForm.this.menuItemSwitchBattery.setVisible(true);
                        } else {
                            LoaderForm.this.menuItemSwitchBattery.setVisible(false);
                        }
                        if (Utils.cleanVersion(LoaderForm.this.lblDisplayLocal.getText()) < 10142 && Utils.cleanVersion(LoaderForm.this.lblDisplayLocal.getText()) >= 10000 && (DISPLAY_TYPE == 1 || DISPLAY_TYPE == 2)) {
                            LoaderForm.this.menuItemSwitchBattery.setVisible(false);
                        }
                        if (DISPLAY_TYPE == 0 && poliniBattery == 1) {
                            LoaderForm.this.menuOptions.setVisible(true);
                            LoaderForm.this.menuItemSwitchBattery.setVisible(true);
                        }
                        String url = "/bin/" + Loader.folder + "/" + boardType + DISPLAY_TYPE + "/config.properties";
                        String ver = Utils.getMotorVersion(url, Loader.offline);
                        LoaderForm.this.lblMotorOnline.setText(ver);
                        int FW_VER_LOADER = Utils.cleanVersion(LoaderForm.this.lblMotorOnline.getText());
                        if (DISPLAY_TYPE >= 1) {
                            if (!LoaderForm.this.SKIP_CHECK_VERSION) {
                                DISPLAY_FAMILY = LoaderForm.this.getDisplayFamily();
                                if (poliniBattery == 3 && DISPLAY_FAMILY < 2) {
                                    LoaderForm.this.lblDisplayLocal.setText(LoaderForm.this.lblDisplayOnline.getText());
                                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.passIcon);
                                } else {
                                    try {
                                        tmp = LoaderForm.this.getSerialDisplayVersion();
                                        if (tmp.equals("")) {
                                            LoaderForm.this.lblDisplayLocal.setText("1.00.00");
                                        } else {
                                            LoaderForm.this.lblDisplayLocal.setText(tmp);
                                        }
                                    }
                                    catch (Exception e) {
                                        LoaderForm.this.lblDisplayLocal.setText("1.00.00");
                                    }
                                }
                                if (!LoaderForm.this.lblDisplayLocal.getText().equals("")) {
                                    sp = null;
                                }
                                String displayFilename = "display.txt";
                                if (DISPLAY_FAMILY >= 2) {
                                    displayFilename = "displayV" + DISPLAY_FAMILY + ".txt";
                                }
                                int displayVersionNumber = Utils.cleanVersion(LoaderForm.this.lblDisplayLocal.getText());
                                if (DISPLAY_TYPE == 2 && displayVersionNumber >= 20000 && displayVersionNumber < 30000) {
                                    displayFilename = "displayV3.txt";
                                } else if (DISPLAY_TYPE == 2 && displayVersionNumber >= 50000 && displayVersionNumber < 60000) {
                                    displayFilename = "displayV7.txt";
                                }
                                int currVerDisplay = Utils.cleanVersion(LoaderForm.this.lblDisplayLocal.getText());
                                if (currVerDisplay < 0) {
                                    LoaderForm.this.lblDisplayLocal.setText("1.00.00");
                                }
                                int lastVerDisplay = Utils.cleanVersion(LoaderForm.this.getDisplayVersion(displayFilename));
                                if (FW_VER_BOARD >= FW_VER_LOADER) {
                                    LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.passIcon);
                                    LoaderForm.this.UPDATE_MOTOR = false;
                                } else {
                                    LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.uploadIcon);
                                    LoaderForm.this.UPDATE_MOTOR = true;
                                }
                                if (DISPLAY_FAMILY == -1) {
                                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.failIcon);
                                    LoaderForm.this.lblDisplayOnline.setText("-----");
                                    LoaderForm.this.UPDATE_DISPLAY = false;
                                } else if (currVerDisplay >= lastVerDisplay) {
                                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.passIcon);
                                    LoaderForm.this.UPDATE_DISPLAY = false;
                                } else {
                                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.uploadIcon);
                                    LoaderForm.this.UPDATE_DISPLAY = true;
                                }
                                if (DISPLAY_TYPE == 1) {
                                    int bt = LoaderForm.this.getCdBtEnabled();
                                    if (bt == 0) {
                                        sp = null;
                                        if (!Serial.sendWriteVarString("cd.btEnabled", "1")) {
                                            Serial.closeConnection();
                                            continue;
                                        }
                                        sp = Serial.getSerialResponse((byte)2, 200L);
                                        if (sp != null) continue;
                                        LoaderForm.this.lblBleAppLocal.setText("1.00.00");
                                        LoaderForm.this.lblBleCoreLocal.setText("1.00.00.00");
                                        continue;
                                    }
                                    tmp = LoaderForm.this.getBtVersion();
                                    if (tmp.equals("")) {
                                        LoaderForm.this.lblBleCoreLocal.setText("1.00.00.00");
                                    } else {
                                        LoaderForm.this.lblBleCoreLocal.setText(tmp);
                                    }
                                    tmp = LoaderForm.this.getBtFwVersion();
                                    if (tmp.equals("")) {
                                        LoaderForm.this.lblBleAppLocal.setText("1.00.00");
                                    } else {
                                        LoaderForm.this.lblBleAppLocal.setText(tmp);
                                    }
                                    int currVerBleCore = Utils.cleanVersion(LoaderForm.this.lblBleCoreLocal.getText());
                                    if (currVerBleCore < 0) {
                                        LoaderForm.this.lblBleCoreLocal.setText("1.00.00.00");
                                    }
                                    int lastVerBleCore = Utils.cleanVersion(LoaderForm.this.getBleCoreVersion());
                                    int currVerBleApp = Utils.cleanVersion(LoaderForm.this.lblBleAppLocal.getText());
                                    if (currVerBleApp < 0) {
                                        LoaderForm.this.lblBleAppLocal.setText("1.00.00");
                                    }
                                    int lastVerBleApp = Utils.cleanVersion(LoaderForm.this.getBleAppVersion());
                                    if (currVerBleCore >= lastVerBleCore) {
                                        LoaderForm.this.lblBleCoreStatus.setIcon(LoaderForm.this.passIcon);
                                        LoaderForm.this.UPDATE_BLE_CORE = false;
                                        if (currVerBleApp >= lastVerBleApp) {
                                            LoaderForm.this.lblBleAppStatus.setIcon(LoaderForm.this.passIcon);
                                            LoaderForm.this.UPDATE_BLE_APP = false;
                                        } else {
                                            LoaderForm.this.lblBleAppStatus.setIcon(LoaderForm.this.uploadIcon);
                                            LoaderForm.this.UPDATE_BLE_APP = true;
                                        }
                                    } else {
                                        LoaderForm.this.lblBleCoreStatus.setIcon(LoaderForm.this.uploadIcon);
                                        LoaderForm.this.lblBleAppStatus.setIcon(LoaderForm.this.uploadIcon);
                                        LoaderForm.this.UPDATE_BLE_CORE = true;
                                        LoaderForm.this.UPDATE_BLE_APP = true;
                                    }
                                    LoaderForm.this.configureSteps();
                                } else {
                                    LoaderForm.this.menuItemRecoveryBle.setVisible(false);
                                    LoaderForm.this.lblBleCore.setVisible(false);
                                    LoaderForm.this.lblBleCoreLocal.setVisible(false);
                                    LoaderForm.this.lblBleCoreOnline.setVisible(false);
                                    LoaderForm.this.lblBleCoreStatus.setVisible(false);
                                    LoaderForm.this.lblBleApp.setVisible(false);
                                    LoaderForm.this.lblBleAppLocal.setVisible(false);
                                    LoaderForm.this.lblBleAppOnline.setVisible(false);
                                    LoaderForm.this.lblBleAppStatus.setVisible(false);
                                    LoaderForm.this.UPDATE_BLE_CORE = false;
                                    LoaderForm.this.UPDATE_BLE_APP = false;
                                }
                                if (!(LoaderForm.this.UPDATE_MOTOR || LoaderForm.this.UPDATE_DISPLAY || LoaderForm.this.UPDATE_BLE_CORE || LoaderForm.this.UPDATE_BLE_APP || LoaderForm.this.isAlreadyUpdateShowed)) {
                                    LoaderForm.this.isAlreadyUpdateShowed = true;
                                    JOptionPane.showMessageDialog(null, Loader.getMsgAlreadyUpdated(), "Info", 1);
                                }
                            }
                        } else {
                            LoaderForm.this.menuItemRecoveryDisplay.setVisible(false);
                            if (!LoaderForm.this.ON_UPDATE) {
                                if (FW_VER_BOARD >= FW_VER_LOADER) {
                                    if (DISPLAY_TYPE >= 2 || DISPLAY_TYPE == 0) {
                                        LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.passIcon);
                                        LoaderForm.this.UPDATE_MOTOR = false;
                                        LoaderForm.this.lblDisplay.setVisible(false);
                                        LoaderForm.this.lblDisplayLocal.setVisible(false);
                                        LoaderForm.this.lblDisplayOnline.setVisible(false);
                                        LoaderForm.this.lblDisplayStatus.setVisible(false);
                                        LoaderForm.this.lblBleCore.setVisible(false);
                                        LoaderForm.this.lblBleCoreLocal.setVisible(false);
                                        LoaderForm.this.lblBleCoreOnline.setVisible(false);
                                        LoaderForm.this.lblBleCoreStatus.setVisible(false);
                                        LoaderForm.this.lblBleApp.setVisible(false);
                                        LoaderForm.this.lblBleAppLocal.setVisible(false);
                                        LoaderForm.this.lblBleAppOnline.setVisible(false);
                                        LoaderForm.this.lblBleAppStatus.setVisible(false);
                                        enBtn = false;
                                        if (DISPLAY_TYPE >= 2) {
                                            JOptionPane.showMessageDialog(null, Loader.getMsgAlreadyUpdated(), "Info", 1);
                                            System.exit(0);
                                        }
                                    }
                                } else {
                                    LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.uploadIcon);
                                    LoaderForm.this.UPDATE_MOTOR = true;
                                }
                            }
                            LoaderForm.this.UPDATE_DISPLAY = false;
                            LoaderForm.this.UPDATE_BLE_CORE = false;
                            LoaderForm.this.UPDATE_BLE_APP = false;
                            LoaderForm.this.lblDisplay.setVisible(false);
                            LoaderForm.this.lblDisplayLocal.setVisible(false);
                            LoaderForm.this.lblDisplayOnline.setVisible(false);
                            LoaderForm.this.lblDisplayStatus.setVisible(false);
                            LoaderForm.this.lblBleCore.setVisible(false);
                            LoaderForm.this.lblBleCoreLocal.setVisible(false);
                            LoaderForm.this.lblBleCoreOnline.setVisible(false);
                            LoaderForm.this.lblBleCoreStatus.setVisible(false);
                            LoaderForm.this.lblBleApp.setVisible(false);
                            LoaderForm.this.lblBleAppLocal.setVisible(false);
                            LoaderForm.this.lblBleAppOnline.setVisible(false);
                            LoaderForm.this.lblBleAppStatus.setVisible(false);
                        }
                    } else if (fwVer.toUpperCase().contains("BIOS")) {
                        BIOS_BOARD = tmp = fwVer.substring(0, fwVer.indexOf("-"));
                        LoaderForm.this.lblMotorLocal.setText(fwVer);
                        if (!LoaderForm.this.SKIP_CHECK_VERSION) {
                            LoaderForm.this.menuItemRecoveryDisplay.setVisible(false);
                            LoaderForm.this.menuItemRecoveryBle.setVisible(false);
                        }
                        enBtn = false;
                        if (!LoaderForm.this.ON_UPDATE) {
                            LoaderForm.this.UPDATE_MOTOR = false;
                            LoaderForm.this.UPDATE_DISPLAY = false;
                            LoaderForm.this.UPDATE_BLE_CORE = false;
                            LoaderForm.this.UPDATE_BLE_APP = false;
                            if (LoaderForm.this.first) {
                                JOptionPane.showMessageDialog(null, Loader.messageBundle.getString("loader.update.turn_on_bike"), "Warning", 2);
                            }
                        }
                        LoaderForm.this.first = false;
                    }
                    LoaderForm.this.menuItemRecoveryDisplay.setEnabled(true);
                    LoaderForm.this.btnUpload.setEnabled(enBtn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (cicleCounter >= 2) {
                    cicleCounter = 0;
                }
                ++cicleCounter;
            }
        }

        private boolean canSwitchFromUartToCAN(String version) {
            int versionNumber = Utils.cleanVersion(version);
            return versionNumber >= 40000 && versionNumber < 50000 || versionNumber >= 28100 && versionNumber < 30000;
        }
    }

    public class SerialMotorUpdater
    extends SwingWorker<Void, Void> {
        private void stopUpdate(String stopCause) {
            try {
                LoaderForm.this.lblMessage.setText(stopCause);
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LoaderForm.this.btnUpload.setEnabled(true);
            LoaderForm.this.scanButton.setEnabled(true);
            LoaderForm.this.menuItemRecoveryMotor.setEnabled(true);
            LoaderForm.this.menuItemRecoveryDisplay.setEnabled(true);
            if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                LoaderForm.this.configureSteps();
            }
            JOptionPane.showMessageDialog(null, stopCause, "Error", 0);
            LoaderForm.this.SKIP_CHECK_VERSION = false;
            LoaderForm.this.UPDATE_FINISHED_WITH_ERROR = true;
            LoaderForm.this.UPDATE_FINISHED_MOTOR = true;
            LoaderForm.this.startPinger();
            this.cancel(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            block46: {
                InputStream parametersInput;
                block45: {
                    block43: {
                        String url;
                        block42: {
                            Thread.currentThread().setName(this.getClass().getName());
                            parametersInput = null;
                            LoaderForm.this.SKIP_CHECK_VERSION = true;
                            LoaderForm.this.btnUpload.setEnabled(false);
                            LoaderForm.this.scanButton.setEnabled(false);
                            LoaderForm.this.menuItemRecoveryMotor.setEnabled(false);
                            LoaderForm.this.menuItemRecoveryDisplay.setEnabled(false);
                            LoaderForm.this.stopPinger();
                            Thread.sleep(1000L);
                            LoaderForm loaderForm = LoaderForm.this;
                            loaderForm.currentStep = loaderForm.currentStep + 1;
                            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_2"));
                            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                            try {
                                String remoteUrl = null;
                                String rulesUrl = null;
                                if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                                    remoteUrl = "/bin/RM/" + BIOS_BOARD + "/rm_micro_XMC4400.bin";
                                    rulesUrl = "/bin/RM/" + BIOS_BOARD + "/rules.properties";
                                } else {
                                    remoteUrl = "/bin/" + Loader.folder + "/" + BIOS_BOARD + "_" + DISPLAY_TYPE + "/micro_XMC4400.bin";
                                    rulesUrl = "/bin/" + Loader.folder + "/" + BIOS_BOARD + "_" + DISPLAY_TYPE + "/rules.properties";
                                }
                                InputStream binStream = Utils.getInputStreamContent(remoteUrl, Loader.offline);
                                if (binStream == null) {
                                    throw new IOException("bin not found");
                                }
                                InputStream rulesStream = Utils.getInputStreamContent(rulesUrl, Loader.offline);
                                if (rulesStream == null) {
                                    throw new IOException("rules not found");
                                }
                                LoaderForm.this.ml = new MicroLoader(binStream);
                                LoaderForm.this.ml.loadRules(rulesStream);
                            }
                            catch (IOException ioe) {
                                this.stopUpdate(Loader.messageBundle.getString("loader.update.no_firmware"));
                                return null;
                            }
                            catch (CheckSumException cse) {
                                this.stopUpdate(Loader.messageBundle.getString("loader.update.wrong_checksum"));
                                return null;
                            }
                            Locale.getDefault();
                            String changeLogName = "changelog_" + Locale.forLanguageTag(Locale.getDefault().toLanguageTag()) + ".txt";
                            String contentUrl = null;
                            String defaultUrl = null;
                            if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                                contentUrl = "/bin/RM/" + BIOS_BOARD + "/CHANGELOG/" + changeLogName;
                                defaultUrl = "/bin/RM/" + BIOS_BOARD + "/CHANGELOG/changelog.txt";
                            } else {
                                contentUrl = "/bin/" + Loader.folder + "/" + BIOS_BOARD + "_" + DISPLAY_TYPE + "/CHANGELOG/" + changeLogName;
                                defaultUrl = "/bin/" + Loader.folder + "/" + BIOS_BOARD + "_" + DISPLAY_TYPE + "/CHANGELOG/changelog.txt";
                            }
                            LoaderForm.this.changeLogForm.showContent(contentUrl, defaultUrl);
                            url = null;
                            if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) break block42;
                            LoaderForm loaderForm2 = LoaderForm.this;
                            loaderForm2.currentStep = loaderForm2.currentStep + 1;
                            LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_3"));
                            LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                            url = "/bin/" + Loader.folder + "/" + BIOS_BOARD + "_" + DISPLAY_TYPE + "/parameters" + MOTOR_TYPE + DISPLAY_TYPE + ".bin";
                            parametersInput = Utils.getInputStreamContent(url, Loader.offline);
                            if (parametersInput == null) {
                                this.stopUpdate(Loader.messageBundle.getString("loader.update.file_not_found"));
                                return null;
                            }
                            break block43;
                        }
                        switch (BIOS_BOARD) {
                            case "MRC1": {
                                LoaderForm loaderForm = LoaderForm.this;
                                loaderForm.currentStep = loaderForm.currentStep + 1;
                                LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_3"));
                                LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                                url = "/bin/RM/" + BIOS_BOARD + "/recovery.bin";
                                parametersInput = Utils.getInputStreamContent(url, Loader.offline);
                                if (parametersInput != null) break;
                                this.stopUpdate(Loader.messageBundle.getString("loader.update.file_not_found"));
                                return null;
                            }
                        }
                    }
                    LoaderForm loaderForm = LoaderForm.this;
                    loaderForm.currentStep = loaderForm.currentStep + 1;
                    LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_4"));
                    LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                    Header h = null;
                    int checkRetry = 0;
                    while (checkRetry < 5) {
                        try {
                            h = LoaderForm.this.ml.checkForHardare();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (h != null) break;
                        ++checkRetry;
                    }
                    if (h == null) {
                        Serial.closeConnection();
                        Thread.sleep(100L);
                        Serial.openConnection(LoaderForm.this.lblSerialPort.getText(), 115200);
                        Thread.sleep(500L);
                        Serial.closeConnection();
                        Thread.sleep(100L);
                        this.stopUpdate(Loader.messageBundle.getString("loader.update.no_hardware"));
                        return null;
                    }
                    if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                        LoaderForm.this.uploadProgressBar.setString(Loader.messageBundle.getString("loader.update.uploading_recovery"));
                    } else {
                        LoaderForm.this.uploadProgressBar.setString(Loader.messageBundle.getString("loader.update.uploading_firmware"));
                    }
                    MicroDescriptor md = LoaderForm.this.ml.getMicroDescriptor(h.getMicroVersion());
                    String msg = "";
                    if (md == null) {
                        this.stopUpdate(Loader.messageBundle.getString("loader.update.no_firmware"));
                        return null;
                    }
                    if (LoaderForm.this.ml.checkRules(h)) {
                        LoaderForm.this.uploadProgressBar.setValue(0);
                        LoaderForm.this.uploadProgressBar.setMaximum(md.getDataSerial().size());
                        msg = LoaderForm.this.ml.serialUpdateFirmwareBios(md, this);
                    } else {
                        msg = Loader.messageBundle.getString("loader.update.firmware_not_valid");
                    }
                    firmwareDetected = false;
                    LoaderForm.this.uploadProgressBar.setValue(0);
                    Thread.sleep(1000L);
                    if (!msg.equals(Loader.messageBundle.getString("loader.update.success"))) {
                        this.stopUpdate(msg);
                        return null;
                    }
                    LoaderForm loaderForm3 = LoaderForm.this;
                    loaderForm3.currentStep = loaderForm3.currentStep + 1;
                    LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_5"));
                    LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                    Serial.sendSetJumpFlag((byte)1);
                    Serial.purge();
                    Thread.sleep(500L);
                    Serial.sendJumpToApplication();
                    Serial.purge();
                    Thread.sleep(500L);
                    try {
                        Serial.closeConnection();
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LoaderForm.this.startPinger();
                    Thread.sleep(100L);
                    LoaderForm.this.firmwareRetry = 300;
                    while (!firmwareDetected) {
                        Thread.sleep(100L);
                        LoaderForm loaderForm4 = LoaderForm.this;
                        loaderForm4.firmwareRetry = loaderForm4.firmwareRetry - 1;
                        if (LoaderForm.this.firmwareRetry > 0) continue;
                        this.stopUpdate(Loader.messageBundle.getString("loader.update.bike"));
                        return null;
                    }
                    int count = 50;
                    while (count > 0) {
                        Thread.sleep(100L);
                        if (fwVer != null || fwVer.startsWith("EP3") || fwVer.startsWith("RM")) break;
                        --count;
                    }
                    if (count <= 0) {
                        this.stopUpdate(Loader.messageBundle.getString("loader.update.bike"));
                        return null;
                    }
                    LoaderForm.this.stopPinger();
                    LoaderForm.this.SKIP_CHECK_VERSION = false;
                    if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) break block45;
                    LoaderForm loaderForm5 = LoaderForm.this;
                    loaderForm5.currentStep = loaderForm5.currentStep + 1;
                    LoaderForm loaderForm6 = LoaderForm.this;
                    loaderForm6.currentStep = loaderForm6.currentStep + 1;
                    LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_6"));
                    LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                    LoaderForm.this.uploadProgressBar.setValue(0);
                    LoaderForm.this.uploadProgressBar.setString(Loader.messageBundle.getString("loader.update.uploading_parameters"));
                    LoaderForm.this.databaseWorker = new SerialDatabaseStringWriter(parametersInput);
                    LoaderForm.this.databaseWorker.execute();
                    break block46;
                }
                boolean enableParameters = false;
                switch (BIOS_BOARD) {
                    case "MRC1": {
                        enableParameters = true;
                    }
                }
                if (enableParameters) {
                    LoaderForm loaderForm = LoaderForm.this;
                    loaderForm.currentStep = loaderForm.currentStep + 1;
                    LoaderForm.this.lblCurrentStep.setText(Loader.messageBundle.getString("loader.step_5"));
                    LoaderForm.this.overallProgressBar.setValue(LoaderForm.this.currentStep);
                    LoaderForm.this.uploadProgressBar.setValue(0);
                    LoaderForm.this.databaseWorker = new SerialDatabaseStringWriter(parametersInput);
                    LoaderForm.this.databaseWorker.execute();
                } else {
                    LoaderForm.this.btnUpload.setEnabled(true);
                    LoaderForm.this.scanButton.setEnabled(true);
                    LoaderForm.this.menuItemRecoveryMotor.setEnabled(true);
                    if (LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                        LoaderForm.this.menuItemRecoveryMotor.setSelected(false);
                        LoaderForm.this.configureSteps();
                    }
                    LoaderForm.this.menuItemRecoveryDisplay.setEnabled(true);
                    Thread.sleep(25L);
                    LoaderForm.this.startPinger();
                    Thread.sleep(2000L);
                    LoaderForm.this.btnUpload.setEnabled(false);
                    LoaderForm.this.scanButton.setEnabled(false);
                    LoaderForm.this.menuItemRecoveryMotor.setEnabled(false);
                    LoaderForm.this.menuItemRecoveryDisplay.setEnabled(false);
                    LoaderForm.this.serialMotorUpdate();
                }
            }
            return null;
        }

        public void printMessage(int value) {
            LoaderForm.this.uploadProgressBar.setValue(value);
        }
    }

    public class UpdateManager
    extends SwingWorker<Void, Void> {
        @Override
        protected Void doInBackground() throws Exception {
            boolean blink;
            Thread.currentThread().setName(this.getClass().getName());
            LoaderForm.this.ON_UPDATE = true;
            LoaderForm.this.UPDATE_FINISHED_WITH_ERROR = false;
            LoaderForm.this.stopPinger();
            LoaderForm.this.menuItemRecoveryDisplay.setEnabled(false);
            LoaderForm.this.menuItemRecoveryMotor.setEnabled(false);
            LoaderForm.this.menuItemRecoveryBle.setEnabled(false);
            LoaderForm.this.btnUpload.setEnabled(false);
            LoaderForm.this.scanButton.setEnabled(false);
            LoaderForm.this.lblCurrentStep.setText("");
            LoaderForm.this.currentStep = 0;
            LoaderForm.this.overallProgressBar.setValue(0);
            LoaderForm.this.uploadProgressBar.setValue(0);
            int totalSteps = 1;
            if (LoaderForm.this.menuItemRecoveryDisplay.isSelected()) {
                LoaderForm.this.ON_RECOVERY = true;
                LoaderForm.this.UPDATE_MOTOR = false;
                LoaderForm.this.UPDATE_DISPLAY = true;
                LoaderForm.this.UPDATE_BLE_CORE = false;
                LoaderForm.this.UPDATE_BLE_APP = false;
            }
            if (ON_BIOS && LoaderForm.this.menuItemRecoveryMotor.isSelected()) {
                LoaderForm.this.ON_RECOVERY = true;
                LoaderForm.this.UPDATE_MOTOR = true;
                LoaderForm.this.UPDATE_DISPLAY = false;
                LoaderForm.this.UPDATE_BLE_CORE = false;
                LoaderForm.this.UPDATE_BLE_APP = false;
                totalSteps += 6;
            }
            if (LoaderForm.this.menuItemRecoveryBle.isSelected()) {
                LoaderForm.this.ON_RECOVERY = true;
                LoaderForm.this.UPDATE_MOTOR = false;
                LoaderForm.this.UPDATE_DISPLAY = false;
                LoaderForm.this.UPDATE_BLE_CORE = true;
                LoaderForm.this.UPDATE_BLE_APP = true;
            }
            LoaderForm.this.UPDATE_FINISHED_DISPLAY = !LoaderForm.this.UPDATE_DISPLAY;
            LoaderForm.this.UPDATE_FINISHED_MOTOR = !LoaderForm.this.UPDATE_MOTOR;
            LoaderForm.this.UPDATE_FINISHED_BLE_CORE = !LoaderForm.this.UPDATE_BLE_CORE;
            LoaderForm.this.UPDATE_FINISHED_BLE_APP = !LoaderForm.this.UPDATE_BLE_APP;
            if (LoaderForm.this.UPDATE_DISPLAY) {
                totalSteps += 6;
            }
            if (LoaderForm.this.UPDATE_MOTOR) {
                totalSteps += 6;
            }
            if (LoaderForm.this.UPDATE_BLE_CORE) {
                totalSteps += 5;
            }
            if (LoaderForm.this.UPDATE_BLE_APP) {
                totalSteps += 6;
            }
            Serial.sendWriteVarString("isInUpdate", "1");
            Thread.sleep(2000L);
            LoaderForm.this.overallProgressBar.setMaximum(totalSteps);
            LoaderForm.this.btnNext.setEnabled(false);
            LoaderForm.this.btnBack.setEnabled(false);
            if (LoaderForm.this.UPDATE_DISPLAY) {
                Serial.sendWriteVarString("enableDisplayCloudDrive", "1");
                DataPacket dp = Serial.getSerialResponse((byte)2, 200L);
                if (dp == null) {
                    LoaderForm.this.UPDATE_FINISHED_WITH_ERROR = true;
                    LoaderForm.this.UPDATE_FINISHED_DISPLAY = true;
                } else {
                    LoaderForm.this.serialUpdateDisplay();
                }
                if (LoaderForm.this.ON_RECOVERY && DISPLAY_FAMILY == 5 || DISPLAY_FAMILY == 6) {
                    LoaderForm.this.getDisplayVersion("displayV" + DISPLAY_FAMILY + ".txt");
                }
                blink = false;
                while (!LoaderForm.this.UPDATE_FINISHED_DISPLAY) {
                    if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                        LoaderForm.this.ON_UPDATE = false;
                        LoaderForm.this.startPinger();
                        break;
                    }
                    Thread.sleep(500L);
                    if (blink) {
                        LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.uploadIcon);
                    } else {
                        LoaderForm.this.lblDisplayStatus.setIcon(null);
                    }
                    boolean bl = blink = !blink;
                    if (!LoaderForm.this.ON_RECOVERY) continue;
                    LoaderForm.this.lblRecovery.setVisible(true);
                    if (blink) {
                        LoaderForm.this.lblRecovery.setForeground(Color.WHITE);
                        continue;
                    }
                    LoaderForm.this.lblRecovery.setForeground(Color.BLACK);
                }
                if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.failIcon);
                } else {
                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblDisplayLocal.setText(LoaderForm.this.lblDisplayOnline.getText());
                }
                LoaderForm.this.stopPinger();
                Thread.sleep(10000L);
            }
            if (LoaderForm.this.UPDATE_MOTOR) {
                LoaderForm.this.serialMotorUpdate();
                blink = false;
                while (!LoaderForm.this.UPDATE_FINISHED_MOTOR) {
                    if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                        LoaderForm.this.ON_UPDATE = false;
                        LoaderForm.this.startPinger();
                        break;
                    }
                    Thread.sleep(500L);
                    if (blink) {
                        LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.uploadIcon);
                    } else {
                        LoaderForm.this.lblMotorStatus.setIcon(null);
                    }
                    boolean bl = blink = !blink;
                    if (!LoaderForm.this.ON_RECOVERY) continue;
                    LoaderForm.this.lblRecovery.setVisible(true);
                    if (blink) {
                        LoaderForm.this.lblRecovery.setForeground(Color.WHITE);
                        continue;
                    }
                    LoaderForm.this.lblRecovery.setForeground(Color.BLACK);
                }
                if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                    LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.failIcon);
                } else {
                    LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblMotorLocal.setText(LoaderForm.this.lblMotorOnline.getText());
                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblDisplayLocal.setText(LoaderForm.this.lblDisplayOnline.getText());
                }
            }
            if (LoaderForm.this.UPDATE_BLE_CORE) {
                LoaderForm.this.serialUpdateBleCore();
                blink = false;
                while (!LoaderForm.this.UPDATE_FINISHED_BLE_CORE) {
                    if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                        LoaderForm.this.ON_UPDATE = false;
                        LoaderForm.this.startPinger();
                        break;
                    }
                    Thread.sleep(500L);
                    if (blink) {
                        LoaderForm.this.lblBleCoreStatus.setIcon(LoaderForm.this.uploadIcon);
                    } else {
                        LoaderForm.this.lblBleCoreStatus.setIcon(null);
                    }
                    boolean bl = blink = !blink;
                    if (!LoaderForm.this.ON_RECOVERY) continue;
                    LoaderForm.this.lblRecovery.setVisible(true);
                    if (blink) {
                        LoaderForm.this.lblRecovery.setForeground(Color.WHITE);
                        continue;
                    }
                    LoaderForm.this.lblRecovery.setForeground(Color.BLACK);
                }
                if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                    LoaderForm.this.lblBleCoreStatus.setIcon(LoaderForm.this.failIcon);
                } else {
                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblDisplayLocal.setText(LoaderForm.this.lblDisplayOnline.getText());
                    LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblMotorLocal.setText(LoaderForm.this.lblMotorOnline.getText());
                    LoaderForm.this.lblBleCoreStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblBleCoreLocal.setText(LoaderForm.this.lblBleCoreOnline.getText());
                }
            }
            if (LoaderForm.this.UPDATE_BLE_APP) {
                LoaderForm.this.serialUpdateBle();
                blink = false;
                while (!LoaderForm.this.UPDATE_FINISHED_BLE_APP) {
                    if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                        LoaderForm.this.ON_UPDATE = false;
                        LoaderForm.this.startPinger();
                        break;
                    }
                    Thread.sleep(500L);
                    if (blink) {
                        LoaderForm.this.lblBleAppStatus.setIcon(LoaderForm.this.uploadIcon);
                    } else {
                        LoaderForm.this.lblBleAppStatus.setIcon(null);
                    }
                    boolean bl = blink = !blink;
                    if (!LoaderForm.this.ON_RECOVERY) continue;
                    LoaderForm.this.lblRecovery.setVisible(true);
                    if (blink) {
                        LoaderForm.this.lblRecovery.setForeground(Color.WHITE);
                        continue;
                    }
                    LoaderForm.this.lblRecovery.setForeground(Color.BLACK);
                }
                if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                    LoaderForm.this.lblBleAppStatus.setIcon(LoaderForm.this.failIcon);
                } else {
                    LoaderForm.this.lblMotorStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblMotorLocal.setText(LoaderForm.this.lblMotorOnline.getText());
                    LoaderForm.this.lblDisplayStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblDisplayLocal.setText(LoaderForm.this.lblDisplayOnline.getText());
                    LoaderForm.this.lblBleCoreStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblBleCoreLocal.setText(LoaderForm.this.lblBleCoreOnline.getText());
                    LoaderForm.this.lblBleAppStatus.setIcon(LoaderForm.this.passIcon);
                    LoaderForm.this.lblBleAppLocal.setText(LoaderForm.this.lblBleAppOnline.getText());
                }
                LoaderForm.this.waitRestart();
            }
            LoaderForm.this.stopPinger();
            Thread.sleep(1000L);
            try {
                Serial.closeConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(1000L);
            try {
                Serial.openConnection(LoaderForm.this.lblSerialPort.getText(), 115200);
            }
            catch (SerialPortException e) {
                e.printStackTrace();
            }
            LoaderForm.this.overallProgressBar.setValue(totalSteps);
            Serial.sendWriteVarString("isInUpdate", "2");
            if (LoaderForm.this.UPDATE_FINISHED_WITH_ERROR) {
                JOptionPane.showMessageDialog(null, Loader.getMsgUpdateFailed(), "Update status", 1);
            } else {
                JOptionPane.showMessageDialog(null, Loader.getMsgUpdateSuccess(), "Update status", 1);
            }
            LoaderForm.this.btnNext.setEnabled(true);
            LoaderForm.this.btnBack.setEnabled(true);
            return null;
        }
    }
}

