/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.ui;

import it.sirius.Constants;
import it.sirius.Loader;
import it.sirius.ui.LoaderForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class DisplayHelpForm
extends JFrame {
    private static final long serialVersionUID = 8624999322584228037L;
    JFrame parent;
    private JLabel label;
    private Image image = null;

    public DisplayHelpForm(JFrame parent) {
        this.parent = parent;
        this.setBounds(parent.getX() + parent.getWidth() + 10, parent.getY(), 350, parent.getHeight());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/img/logo.png")));
        this.setTitle(Loader.messageBundle.getString("display.title"));
        this.getContentPane().setLayout(new BorderLayout());
        this.label = new JLabel("");
        this.getContentPane().add((Component)this.label, "Center");
        this.setDefaultCloseOperation(2);
    }

    public void showContent(int family) {
        this.setTitle("Display " + Loader.messageBundle.getString("loader.display.family." + family));
        try {
            this.image = Loader.offline ? ImageIO.read(LoaderForm.class.getResourceAsStream("/bin/Media/" + family + "_Display_Help.jpeg")) : ImageIO.read(new URL(String.valueOf(new String(Constants.BASE_URL)) + "/bin/" + "Media/" + family + "_Display_Help.jpeg"));
        }
        catch (Exception e) {
            this.dispose();
            return;
        }
        if (this.image == null) {
            this.dispose();
            return;
        }
        this.setBounds(this.parent.getX() + this.parent.getWidth() + 10, this.parent.getY(), this.image.getWidth(null) + 30, this.image.getHeight(null));
        this.label.setIcon(new ImageIcon(this.image));
        this.pack();
        this.setVisible(true);
    }
}

