/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.ui;

import it.sirius.Loader;
import it.sirius.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class ChangeLogForm
extends JFrame {
    private static final long serialVersionUID = 8624999322584228037L;
    private JTextArea textArea;

    public ChangeLogForm(JFrame parent) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(parent.getX() + parent.getWidth() + 10, d.height / 2 - parent.getHeight() / 2 + 14, 350, parent.getHeight() + 5);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/img/logo.png")));
        this.setTitle(Loader.messageBundle.getString("changelog.title"));
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(2);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setBounds(10, 10, this.getWidth() - 25, this.getHeight() - 48);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.setDefaultCloseOperation(2);
    }

    public void showContent(String contentUrl, String defaultUrl) {
        InputStream clStream = Utils.getInputStreamContent(contentUrl, Loader.offline);
        if (clStream == null) {
            clStream = Utils.getInputStreamContent(defaultUrl, Loader.offline);
        }
        if (clStream != null) {
            String content = new BufferedReader(new InputStreamReader(clStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            String utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
            this.textArea.setText(utf8EncodedString);
            this.setVisible(true);
        }
    }
}

