/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.test;

import it.sirius.Loader;
import it.sirius.console.DataPacket;
import it.sirius.console.Serial;
import it.sirius.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class LaunchLairdAppTest {
    public static void main(String[] args) throws InterruptedException, IOException, SerialPortException {
        System.out.println("Launch Laird app test");
        System.out.println();
        String[] ports = SerialPortList.getPortNames();
        String com = "";
        String[] stringArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            try {
                String data;
                Serial.openConnection(port, 115200);
                Serial.sendReadVarString("HWVer");
                DataPacket sp = Serial.getSerialResponse((byte)22, 200L);
                Serial.closeConnection();
                if (sp != null && (data = new String(sp.data).toUpperCase()).contains("MRC")) {
                    com = port;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        if (com.isEmpty()) {
            System.out.println("no bike found");
            Serial.closeConnection();
            return;
        }
        System.out.println("downloading app...");
        String userHome = "c:\\tmp";
        File directory = new File(String.valueOf(userHome) + "/Polini");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String exeFilename = "bleCoreUpdater.exe";
        String binFilename = "bleCore.uwf";
        String localBaseUrl = directory.getAbsolutePath();
        if (!(localBaseUrl = localBaseUrl.replace("\\", "/")).endsWith("/")) {
            localBaseUrl = String.valueOf(localBaseUrl) + "/";
        }
        String remoteBaseUrl = "/bin/" + Loader.folder + "/Ble/";
        InputStream prg = Utils.getInputStreamContent(String.valueOf(remoteBaseUrl) + exeFilename, Loader.offline);
        File targetExeFile = new File(String.valueOf(localBaseUrl) + exeFilename);
        Files.copy(prg, targetExeFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        prg.close();
        prg = null;
        InputStream bin = Utils.getInputStreamContent(String.valueOf(remoteBaseUrl) + binFilename, Loader.offline);
        File targetBinFile = new File(String.valueOf(localBaseUrl) + binFilename);
        Files.copy(bin, targetBinFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        bin.close();
        bin = null;
        Thread.sleep(500L);
        System.out.println("done.");
        System.out.println();
        System.out.println("setting board...");
        Serial.openConnection(com, 115200);
        Serial.sendWriteVarString("cd.btEnabled", "1");
        Thread.sleep(1500L);
        Serial.sendWriteVarString("mode_BT", "1");
        Thread.sleep(100L);
        Serial.sendWriteVarString("USB_Trough_BT", "1");
        Thread.sleep(100L);
        System.out.println("done.");
        System.out.println();
        if (com.startsWith("COM")) {
            com = com.substring(3);
        }
        Path currentRelativePath = Paths.get(localBaseUrl, new String[0]);
        String s = currentRelativePath.toAbsolutePath().toString();
        System.out.println("Laird app at: " + currentRelativePath);
        System.out.println("launching app...");
        Thread.sleep(5000L);
        int r = Utils.executeProcessWindows(new String[]{"cmd.exe", "/c", String.valueOf(s) + "\\" + exeFilename, "TGT=BL65X", "UWF=" + s + "\\" + binFilename, "COM=" + com, "ACCEPT", "AUTOMODE"});
        System.out.println("exit code = " + r);
        try {
            Serial.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

