/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.test;

import it.sirius.Loader;
import it.sirius.hardware.Header;
import it.sirius.hardware.MicroDescriptor;
import it.sirius.hardware.MicroLoader;
import it.sirius.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class DownloadFirmwareMotorTest {
    public static void main(String[] args) throws Exception {
        String remoteUrl = null;
        String rulesUrl = null;
        InputStream binStream = Utils.getInputStreamContent(remoteUrl, Loader.offline);
        if (binStream == null) {
            throw new IOException("bin not found");
        }
        InputStream rulesStream = Utils.getInputStreamContent(rulesUrl, Loader.offline);
        if (rulesStream == null) {
            throw new IOException("rules not found");
        }
        MicroLoader ml = new MicroLoader(binStream);
        ml.loadRules(rulesStream);
        Header h = null;
        int checkRetry = 0;
        while (checkRetry < 5) {
            h = ml.checkForHardare();
            if (h != null) break;
            ++checkRetry;
        }
        MicroDescriptor md = ml.getMicroDescriptor(h.getMicroVersion());
        String msg = "";
        if (!ml.checkRules(h)) {
            throw new Exception("check rules failed");
        }
        msg = ml.serialUpdateFirmwareBios(md, null);
        System.out.println(msg);
    }
}

