/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.hardware.frames;

public class DisplayPacket {
    byte[][] frames = null;

    public DisplayPacket(byte cmd, byte[] data, short frameLength) {
        int n = data.length % frameLength == 0 ? data.length / frameLength : data.length / frameLength + 1;
        int r = 0;
        this.frames = new byte[n][];
        int i = 0;
        while (i < n) {
            int j;
            byte[] f;
            int k = 0;
            if (i < n - 1) {
                f = new byte[frameLength + 3];
                f[k++] = cmd;
                f[k++] = (byte)frameLength;
                j = 0;
                while (j < frameLength) {
                    f[k++] = data[r++];
                    ++j;
                }
            } else {
                f = new byte[data.length - r + 3];
                f[k++] = cmd;
                f[k++] = (byte)(data.length - r);
                j = r;
                while (j < data.length) {
                    f[k++] = data[r++];
                    ++j;
                }
            }
            byte checksum = f[0];
            int j2 = 1;
            while (j2 < k) {
                checksum = (byte)(checksum ^ f[j2]);
                ++j2;
            }
            f[k++] = checksum;
            this.frames[i] = f;
            ++i;
        }
    }

    public int getFrameNumber() {
        return this.frames.length;
    }

    public byte[] getFrame(int i) {
        return this.frames[i];
    }
}

