/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.hardware;

import it.sirius.Loader;
import it.sirius.console.DataPacket;
import it.sirius.console.Serial;
import it.sirius.hardware.Header;
import it.sirius.hardware.MicroDescriptor;
import it.sirius.hardware.Rule;
import it.sirius.hardware.frames.FlashPage;
import it.sirius.ui.LoaderForm;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;

public class MicroLoader {
    private ArrayList<Rule> rules = new ArrayList();
    protected Hashtable<String, MicroDescriptor> map = new Hashtable();

    public MicroLoader(InputStream bin) throws Exception {
        if (bin != null) {
            MicroDescriptor md = new MicroDescriptor(bin);
            this.map.put(md.getMicroCode(), md);
            bin.close();
            bin = null;
        }
    }

    public void loadRules(InputStream rulesStream) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(rulesStream));
        while ((line = in.readLine()) != null) {
            try {
                if (line.isEmpty()) continue;
                this.rules.add(new Rule(line));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        in.close();
        in = null;
    }

    public MicroDescriptor getMicroDescriptor(String picVersion) {
        return this.map.get(picVersion);
    }

    public boolean checkRules(Header h) {
        boolean found = false;
        for (Rule r : this.rules) {
            if (!r.hardware.equals(h.getHardware())) continue;
            found = true;
            if (r.preparation != null && !r.preparation.equals(h.getPreparation())) {
                found = false;
            }
            if (r.versionMin != -1.0 && r.versionMax == -1.0 && r.versionMin != h.getVersionNumber()) {
                found = false;
            }
            if (r.versionMin != -1.0 && r.versionMax != -1.0 && (h.getVersionNumber() < r.versionMin || h.getVersionNumber() > r.versionMax)) {
                found = false;
            }
            if (found) break;
        }
        return found;
    }

    public String serialUpdateFirmwareBios(MicroDescriptor md, LoaderForm.SerialMotorUpdater updater) {
        try {
            DataPacket sp = null;
            Serial.sendUploadReady(md.getDataSerial().size());
            sp = Serial.getSerialResponse((byte)-78, 200L);
            if (sp == null) {
                return String.valueOf(Loader.messageBundle.getString("loader.update.no_response")) + " Code: N";
            }
            if (sp.data.length == 0) {
                return String.valueOf(Loader.messageBundle.getString("loader.update.no_response")) + " Code: Z";
            }
            if ((char)sp.data[0] != 'K') {
                return String.valueOf(Loader.messageBundle.getString("loader.update.no_response")) + " Code: K";
            }
            int k = 0;
            int retry = 0;
            while (k < md.getDataSerial().size()) {
                FlashPage fp = md.getFlashPage(k);
                Serial.sendUploadFrame(fp.data);
                sp = Serial.getSerialResponse((byte)-77, 10000L);
                if (sp == null) {
                    return String.valueOf(Loader.messageBundle.getString("loader.update.break_response")) + " T ";
                }
                if ((char)sp.data[0] == 'K') {
                    retry = 0;
                    ++k;
                } else if ((char)sp.data[0] == 'N') {
                    if (retry > 3) {
                        return String.valueOf(Loader.messageBundle.getString("loader.update.flash_error")) + " N ";
                    }
                    ++retry;
                } else {
                    if ((char)sp.data[0] == 'E') {
                        return String.valueOf(Loader.messageBundle.getString("loader.update.flash_error")) + " E ";
                    }
                    if ((char)sp.data[0] == 'W') {
                        return String.valueOf(Loader.messageBundle.getString("loader.update.flash_error")) + " W ";
                    }
                }
                if (updater == null) continue;
                updater.printMessage(k);
            }
        }
        catch (Exception e) {
            try {
                Serial.closeConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.valueOf(Loader.messageBundle.getString("loader.update.upload_error")) + " D ";
        }
        return Loader.messageBundle.getString("loader.update.success");
    }

    public Header checkForHardare() throws Exception {
        Header h = null;
        Serial.sendUploadStart();
        DataPacket sp = Serial.getSerialResponse((byte)-79, 200L);
        if (sp != null) {
            h = new Header(sp.data);
        }
        return h;
    }
}

