/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.hardware;

import it.sirius.hardware.CheckSumException;
import it.sirius.hardware.frames.FlashPage;
import it.sirius.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MicroDescriptor {
    private final String BLOCK_SIZE = "BLOCK_SIZE";
    private final String WORD_FOR_LINE = "WORD_FOR_LINE";
    private final String JUMP_BYTES = "JUMP_BYTES";
    private final String CPU_TYPE = "CPU_TYPE";
    private final String START_ADDRESS = "STR_ADDR";
    private final String END_ADDRESS_SERIAL = "END_ADDR_COM";
    public final int BYTES_PER_WORD = 2;
    private Hashtable<String, String> header = new Hashtable();
    protected ArrayList<FlashPage> dataSerial = new ArrayList();
    protected int startAddress = 0;
    protected int endAddressSerial = 1000000000;

    public MicroDescriptor(InputStream binFile) throws IOException, CheckSumException {
        int dataStart;
        int len;
        this.header = new Hashtable();
        this.dataSerial = new ArrayList();
        String head = "";
        byte[] rawData = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        while ((len = binFile.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        os.flush();
        rawData = os.toByteArray();
        int index = 0;
        int i = dataStart = 0;
        while (i < rawData.length) {
            head = String.valueOf(head) + (char)rawData[i];
            ++index;
            if (head.toLowerCase().indexOf("</head>") != -1) {
                this.splitHeader(head);
                break;
            }
            ++i;
        }
        if (this.header.get("STR_ADDR") != null) {
            this.startAddress = Integer.parseInt(this.header.get("STR_ADDR"));
        }
        if (this.header.get("END_ADDR_COM") != null) {
            this.endAddressSerial = Integer.parseInt(this.header.get("END_ADDR_COM"));
        }
        boolean b = false;
        int address = -1;
        String addressTmp = "";
        int size = -1;
        int i2 = ++index;
        while (i2 < rawData.length) {
            if (!b) {
                if ((addressTmp = String.valueOf(addressTmp) + (char)rawData[i2]).toUpperCase().indexOf("</ADDR>") != -1) {
                    addressTmp = addressTmp.toUpperCase().replace("<ADDR>", "").replace("</ADDR>", "");
                    address = Integer.parseInt(addressTmp);
                    addressTmp = "";
                    ++i2;
                    b = !b;
                }
                ++i2;
                continue;
            }
            int remainBytes = rawData.length - i2;
            size = this.getBlockSize();
            if (remainBytes - size < 0) {
                size = remainBytes;
            }
            byte[] block = new byte[size];
            int x = 0;
            while (x < size) {
                block[x] = rawData[i2];
                ++i2;
                ++x;
            }
            if (address == 0 && this.header.get("JUMP_BYTES") != null) {
                int jp = 0;
                while (jp < this.getJumpBytes().length) {
                    block[jp] = this.getJumpBytes()[jp];
                    ++jp;
                }
            }
            int ii = 0;
            byte[] buf = new byte[block.length + 20];
            buf[ii++] = (byte)(address >> 16 & 0xFF);
            buf[ii++] = (byte)(address >> 8 & 0xFF);
            buf[ii++] = (byte)(address & 0xFF);
            buf[ii++] = (byte)(size >> 8 & 0xFF);
            buf[ii++] = (byte)(size & 0xFF);
            int z2 = 0;
            while (z2 < block.length) {
                buf[ii++] = block[z2];
                ++z2;
            }
            byte crc = 0;
            int j = 0;
            while (j < ii) {
                crc = (byte)(crc - (buf[j] & 0xFF));
                ++j;
            }
            buf[ii++] = crc;
            this.dataSerial.add(new FlashPage(buf, ii, address));
            boolean bl = b = !b;
        }
    }

    public ArrayList<FlashPage> getDataSerial() {
        return this.dataSerial;
    }

    public FlashPage getFlashPage(int index) {
        if (this.dataSerial.get((int)index).address >= this.startAddress && this.dataSerial.get((int)index).address < this.endAddressSerial) {
            return this.dataSerial.get(index);
        }
        return null;
    }

    public String getMicroCode() {
        String cpuType;
        String microCode = null;
        switch (cpuType = this.header.get("CPU_TYPE")) {
            case "XMC4400": {
                microCode = "80";
            }
        }
        return microCode;
    }

    public byte[] getJumpBytes() {
        return Utils.hexStringToByteArray(this.header.get("JUMP_BYTES"));
    }

    public int getBlockSize() {
        int a = Integer.parseInt(this.header.get("BLOCK_SIZE"));
        int b = Integer.parseInt(this.header.get("WORD_FOR_LINE"));
        int result = a * b * 2;
        return result;
    }

    private void splitHeader(String head) {
        head = head.toUpperCase().replace("<HEAD>", "").replace("</HEAD>", "");
        StringTokenizer st = new StringTokenizer(head, "\n");
        while (st.hasMoreElements()) {
            StringTokenizer row = new StringTokenizer(st.nextToken(), "\t");
            String name = row.nextToken();
            String value = row.nextToken();
            if (value.startsWith("0X")) {
                value = value.substring(2);
            }
            this.header.put(name, value);
        }
    }
}

