/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.hardware;

public class Header {
    public byte[] b = new byte[19];
    public static final int ID_TYPE_PIC = 2;
    public static final int PRG_VERSION_START = 4;
    public static final int PRG_VERSION_END = 15;

    public Header(byte[] buffer) {
        if (buffer.length >= this.b.length) {
            System.arraycopy(buffer, 0, this.b, 0, this.b.length);
        }
    }

    public String getFullVersion() {
        String v = "";
        int i = 4;
        while (i <= 15) {
            v = String.valueOf(v) + (char)this.b[i];
            ++i;
        }
        return v;
    }

    public String getHardware() {
        String v = "";
        int i = 4;
        while (i < 7) {
            v = String.valueOf(v) + (char)this.b[i];
            ++i;
        }
        return v.toUpperCase();
    }

    public String getPreparation() {
        return ("" + (char)this.b[8]).toUpperCase();
    }

    public double getVersionNumber() {
        String v = "";
        int i = 10;
        while (i < 15) {
            v = String.valueOf(v) + (char)this.b[i];
            ++i;
        }
        return Double.parseDouble(v);
    }

    public String getMicroVersion() {
        return String.format("%02x", this.b[2] & 0xFF).toUpperCase();
    }
}

