/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.db;

import it.sirius.db.Value;
import it.sirius.utils.Md5;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ValuesList {
    private ArrayList<Value> values = new ArrayList();

    public int getValuesSize() {
        return this.values.size();
    }

    public boolean loadFromCryptedStream(InputStream inputStream) throws Exception {
        byte[] key = new byte[]{77, 84, 82, 67, 84, 82, 76};
        int noBytes = inputStream.available();
        byte[] crypt = new byte[noBytes + 1];
        String result = "";
        int x = 0;
        while (x < noBytes) {
            crypt[x] = (byte)inputStream.read();
            ++x;
        }
        int ii = 0;
        while (ii < crypt.length) {
            char ret = (char)(crypt[ii] ^ key[ii % 4]);
            result = String.valueOf(result) + ret;
            ++ii;
        }
        result = result.substring(0, result.length() - 2);
        String md5String = "";
        String md5 = "";
        String[] vars = result.split("\n");
        int i = 0;
        while (i < vars.length) {
            StringTokenizer st = new StringTokenizer(vars[i], "\t");
            String name = null;
            String value = null;
            try {
                name = st.nextToken();
                value = st.nextToken();
            }
            catch (Exception e) {
                throw new Exception("invalid file format");
            }
            if (!name.toUpperCase().equals("MD5")) {
                md5String = String.valueOf(md5String) + name + "/" + value + ";";
            } else {
                md5 = value;
            }
            if (!name.toUpperCase().equals("OSCVERSION") && !name.toUpperCase().equals("MD5")) {
                this.values.add(new Value(name, value));
            }
            ++i;
        }
        return md5.equals(Md5.getHexDigest(md5String));
    }

    public Value getValueAt(int pos) {
        if (pos < 0) {
            return null;
        }
        if (this.values.size() == 0) {
            return null;
        }
        if (pos >= this.values.size()) {
            return null;
        }
        return this.values.get(pos);
    }

    public void addValue(Value v) {
        this.values.add(v);
    }

    public boolean loadFromStream(InputStream inputStream) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        String md5String = "";
        String md5 = "";
        while ((line = in.readLine()) != null) {
            System.out.println(line);
            StringTokenizer st = new StringTokenizer(line, "\t");
            String name = null;
            String value = null;
            try {
                name = st.nextToken();
                value = st.nextToken();
            }
            catch (Exception e) {
                e.printStackTrace();
                in.close();
                in = null;
                throw new Exception("invalid file format, must be name+'tab'+value");
            }
            if (!name.toUpperCase().equals("MD5")) {
                md5String = String.valueOf(md5String) + name + "/" + value + ";";
            } else {
                md5 = value;
            }
            if (name.toUpperCase().equals("OSCVERSION") || name.toUpperCase().equals("MD5")) continue;
            this.values.add(new Value(name, value));
        }
        in.close();
        in = null;
        System.out.println("MD5 file = " + md5);
        System.out.println("MD5 vars = " + Md5.getHexDigest(md5String));
        return md5.equals(Md5.getHexDigest(md5String));
    }

    public boolean loadFromFile(String filename) throws Exception {
        return this.loadFromStream(new FileInputStream(new File(filename)));
    }

    public ArrayList<Value> getValues() {
        return this.values;
    }
}

