/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.db;

import it.sirius.console.DataPacket;
import it.sirius.console.Serial;
import it.sirius.db.ValuesList;
import java.io.InputStream;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class SerialDatabaseStringWriter
extends SwingWorker<Void, Void> {
    private String filename;
    private InputStream parameters;
    private boolean crypted;
    private JProgressBar progressBar;

    public SerialDatabaseStringWriter(String filename, InputStream parameters, boolean crypted) {
        this.filename = filename;
        this.parameters = parameters;
        this.crypted = crypted;
    }

    @Override
    protected Void doInBackground() throws Exception {
        ValuesList vl;
        block16: {
            vl = new ValuesList();
            try {
                if (this.filename != null || this.parameters != null) {
                    Thread.sleep(200L);
                    break block16;
                }
                this.cancel(true);
                return null;
            }
            catch (Exception ef) {
                ef.printStackTrace(System.out);
                Thread.sleep(1000L);
                Thread.sleep(100L);
                this.cancel(true);
                return null;
            }
        }
        boolean md5 = false;
        if (this.filename != null) {
            md5 = vl.loadFromFile(this.filename);
            if (!md5) {
                Thread.sleep(100L);
                throw new Exception();
            }
        } else if (this.parameters != null) {
            System.out.println("Found parameters file into jar...");
            md5 = this.crypted ? vl.loadFromCryptedStream(this.parameters) : vl.loadFromStream(this.parameters);
            if (this.parameters != null) {
                System.out.println("closing parameters input stream");
                this.parameters.close();
                this.parameters = null;
            }
            if (!md5) {
                Thread.sleep(100L);
                throw new Exception();
            }
        } else {
            throw new Exception();
        }
        Thread.sleep(100L);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(vl.getValuesSize() - 1);
        int i = 0;
        while (i < 3) {
            System.out.println("Send on db i=" + i);
            Serial.sendOnDb(1);
            Thread.sleep(100L);
            ++i;
        }
        System.out.println("parameters =  " + vl.getValuesSize());
        i = 0;
        while (i < vl.getValuesSize()) {
            int retry = 10;
            String variableName = vl.getValueAt(i).getName();
            while (retry > 0) {
                Serial.sendWriteVarString(variableName, vl.getValueAt(i).getValue());
                System.out.println("write retry = " + retry + " " + variableName);
                DataPacket sp = Serial.getSerialResponse((byte)2, 200L);
                if (sp != null) {
                    System.out.println("write variable ok");
                    this.updateProgress(i);
                    break;
                }
                --retry;
            }
            if (retry == 0) {
                this.updateProgress(i);
            }
            Thread.sleep(10L);
            ++i;
        }
        Thread.sleep(50L);
        Serial.sendOnDb(0);
        Thread.sleep(100L);
        Serial.sendReboot();
        Thread.sleep(1000L);
        return null;
    }

    public void updateProgress(int value) {
        this.progressBar.setValue(value);
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }
}

