/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.db;

import it.sirius.console.DataPacket;
import it.sirius.console.Serial;
import it.sirius.console.Variable;
import it.sirius.db.Database;
import it.sirius.db.ValuesList;
import it.sirius.utils.Hex;
import it.sirius.utils.Utils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class SerialDatabaseIndexWriter
extends SwingWorker<Void, Void> {
    private String filename;
    private InputStream parameters;
    private boolean crypted;
    private Database db;
    private JProgressBar progressBar;

    public SerialDatabaseIndexWriter(String filename, InputStream parameters, boolean crypted) {
        this.filename = filename;
        this.parameters = parameters;
        this.crypted = crypted;
    }

    public void setDatabase(Database database) {
        this.db = database;
    }

    public void setProgressBar(JProgressBar pb) {
        this.progressBar = pb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Void doInBackground() throws Exception {
        ValuesList vl = new ValuesList();
        try {
            if (this.filename != null || this.parameters != null) {
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(1699);
                if (this.db == null) {
                    Thread.sleep(100L);
                    return null;
                }
                Thread.sleep(500L);
            }
            boolean md5 = false;
            if (this.filename != null) {
                md5 = vl.loadFromFile(this.filename);
                if (!md5) {
                    Thread.sleep(100L);
                    throw new Exception();
                }
            } else {
                if (this.parameters == null) {
                    throw new Exception();
                }
                md5 = this.crypted ? vl.loadFromCryptedStream(this.parameters) : vl.loadFromStream(this.parameters);
                if (this.parameters != null) {
                    this.parameters.close();
                    this.parameters = null;
                }
                if (!md5) {
                    Thread.sleep(100L);
                    throw new Exception();
                }
            }
            if (!md5) {
                Thread.sleep(100L);
                throw new Exception();
            }
            Thread.sleep(100L);
            Thread.sleep(100L);
        }
        catch (Exception ef) {
            ef.printStackTrace(System.out);
            Thread.sleep(1000L);
            Thread.sleep(100L);
            this.cancel(true);
            return null;
        }
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(vl.getValuesSize() - 1);
        int i = 0;
        while (i < 3) {
            System.out.println("Send on db i=" + i);
            Serial.sendOnDb(1);
            Thread.sleep(100L);
            ++i;
        }
        System.out.println("parameters =  " + vl.getValuesSize());
        float dbVer = Serial.getDatabaseVersion();
        boolean extended = (double)dbVer >= 1.05;
        int i2 = 0;
        while (i2 < vl.getValuesSize()) {
            Variable v = this.db.getVariable(vl.getValueAt(i2).getName());
            if (v == null) {
                System.out.println("variable " + vl.getValueAt(i2).getName() + " not found...");
                Thread.sleep(50L);
            } else if (!v.m_saved_eeprom) {
                System.out.println("variable " + v.m_name + " can not be wrote...");
                Thread.sleep(50L);
            } else {
                String value = vl.getValueAt(i2).getValue();
                System.out.println("variable " + v.m_name + " found...");
                int dataSize = 0;
                byte[] dataBytes = null;
                if (v.m_name.toUpperCase().equals("PROGDATE")) {
                    Calendar c = Calendar.getInstance();
                    int dd = c.get(5);
                    int mm = c.get(2) + 1;
                    int yyyy = c.get(1) - 2000;
                    String day = "";
                    if (dd < 10) {
                        day = "0";
                    }
                    day = String.valueOf(day) + dd;
                    String month = "";
                    if (mm < 10) {
                        month = "0";
                    }
                    month = String.valueOf(month) + mm;
                    value = String.valueOf(day) + month + yyyy;
                }
                switch (v.m_type) {
                    case 4: {
                        value = String.valueOf(value) + "\u0000";
                        dataBytes = value.getBytes();
                        dataSize = dataBytes.length;
                        break;
                    }
                    case 3: {
                        value = value.replace(",", ".");
                        float f = Float.parseFloat(value);
                        if (v.isCoeffEnabled() && v.getCoeIdx() != -1) {
                            Variable coeff = Serial.getCoexVariable(v.getCoeIdx(), this.db.isDnPresent(), extended);
                            f /= coeff.getValueAsFloat();
                        }
                        byte[] fv = ByteBuffer.allocate(4).putFloat(f).order(ByteOrder.LITTLE_ENDIAN).array();
                        fv = Utils.flipBytes(fv);
                        dataBytes = fv;
                        dataSize = 4;
                        break;
                    }
                    case 0: {
                        byte byteValue;
                        if (v.m_ishex || value.toUpperCase().startsWith("0X")) {
                            value = value.toLowerCase().replaceFirst("0X", "");
                            byteValue = Hex.hexStringToByte(value);
                        } else {
                            int s = Integer.parseInt(value);
                            byteValue = (byte)(s & 0xFF);
                        }
                        if (v.isCoeffEnabled() && v.getCoeIdx() != -1) {
                            Variable coeff = Serial.getCoexVariable(v.getCoeIdx(), this.db.isDnPresent(), extended);
                            byteValue = (byte)((float)byteValue / coeff.getValueAsFloat());
                        }
                        dataBytes = new byte[]{byteValue};
                        dataSize = 1;
                        break;
                    }
                    case 1: {
                        byte[] sb;
                        if (v.m_ishex || value.toUpperCase().startsWith("0X")) {
                            value = value.toLowerCase().replaceFirst("0X", "");
                            sb = Hex.hexStringToByteArray(value);
                        } else {
                            float shortValue = Float.parseFloat(value);
                            if (v.isCoeffEnabled() && v.getCoeIdx() != -1) {
                                Variable coeff = Serial.getCoexVariable(v.getCoeIdx(), this.db.isDnPresent(), extended);
                                shortValue = (short)(shortValue / coeff.getValueAsFloat());
                            }
                            short s = (short)shortValue;
                            sb = ByteBuffer.allocate(2).putShort(s).order(ByteOrder.LITTLE_ENDIAN).array();
                        }
                        sb = Utils.flipBytes(sb);
                        dataBytes = sb;
                        dataSize = 2;
                        break;
                    }
                    case 2: {
                        byte[] ib;
                        if (v.m_ishex || value.toUpperCase().startsWith("0X")) {
                            value = value.toUpperCase().replaceFirst("0X", "");
                            ib = Hex.hexStringToByteArray(value);
                        } else {
                            float intValue = Float.parseFloat(value);
                            if (v.isCoeffEnabled() && v.getCoeIdx() != -1) {
                                Variable coeff = Serial.getCoexVariable(v.getCoeIdx(), this.db.isDnPresent(), extended);
                                intValue = (int)(intValue / coeff.getValueAsFloat());
                            }
                            int s = (int)intValue;
                            ib = ByteBuffer.allocate(4).putInt(s).order(ByteOrder.LITTLE_ENDIAN).array();
                        }
                        ib = Utils.flipBytes(ib);
                        dataBytes = ib;
                        dataSize = 4;
                        break;
                    }
                }
                int retry = 10;
                while (retry > 0) {
                    Serial.sendWriteVar(v.m_index, dataBytes, dataSize, extended);
                    DataPacket sp = Serial.getSerialResponse(new byte[]{2, 6}, 200L);
                    if (sp != null) {
                        int indexReceived = sp.data[0] & 0xFF;
                        if (sp.cmd == 6) {
                            indexReceived += 255;
                        }
                        if (indexReceived == v.m_index) {
                            System.out.println("write variable ok");
                            break;
                        }
                    } else {
                        System.out.println("NO CORRECT RESPONSE");
                    }
                    --retry;
                }
                this.updateProgress(i2);
                Thread.sleep(10L);
            }
            ++i2;
        }
        Serial.sendOnDb(0);
        Thread.sleep(100L);
        Serial.sendReboot();
        Thread.sleep(200L);
        Thread.sleep(1000L);
        return null;
    }

    public void updateProgress(int value) {
        this.progressBar.setValue(value);
    }
}

