/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.db;

import it.sirius.console.Variable;
import it.sirius.db.Value;
import it.sirius.utils.Md5;
import it.sirius.utils.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;

public class Database {
    private float version;
    private boolean dnPresent;
    private ArrayList<Variable> variables;
    private ArrayList<String> retainVariables;

    public Database(float version, boolean dnPresent) {
        this.version = version;
        this.dnPresent = dnPresent;
        this.variables = new ArrayList();
        this.retainVariables = new ArrayList();
    }

    public float getversion() {
        return this.version;
    }

    public boolean isDnPresent() {
        return this.dnPresent;
    }

    public int getDatabaseSize() {
        return this.variables.size();
    }

    public int getRetainVariablesSize() {
        return this.retainVariables.size();
    }

    public ArrayList<String> checkMissingParameters(ArrayList<Value> values) {
        ArrayList<String> m = new ArrayList<String>();
        int i = 0;
        while (i < this.retainVariables.size()) {
            boolean found = false;
            int j = 0;
            while (j < values.size()) {
                if (values.get(j).getName().equals(this.retainVariables.get(i))) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                m.add(this.retainVariables.get(i));
            }
            ++i;
        }
        return m;
    }

    public void saveToFile(String filename) {
        StringBuilder sb = new StringBuilder();
        StringBuilder md5 = new StringBuilder();
        sb.append("OscVersion\t1.70\r\n");
        md5.append("OscVersion/1.70;");
        int i = 0;
        while (i < this.getDatabaseSize()) {
            try {
                Variable v = this.getVariable(i);
                if (!v.m_name.equals("MD5") && v.m_saved_eeprom) {
                    String writeValue = v.getValueAsString();
                    if (writeValue.equals("")) {
                        writeValue = "0";
                    }
                    if (v.m_name.equals("PARDate")) {
                        Calendar c = Calendar.getInstance();
                        int d = c.get(5);
                        int m = c.get(2) + 1;
                        int y = c.get(1) - 2000;
                        String day = "";
                        if (d < 10) {
                            day = "0";
                        }
                        day = String.valueOf(day) + d;
                        String month = "";
                        if (m < 10) {
                            month = "0";
                        }
                        month = String.valueOf(month) + m;
                        writeValue = String.valueOf(day) + month + y;
                    } else if (v.m_name.equals("PARVer")) {
                        writeValue = "01.00.00";
                    } else if (!writeValue.equals("0") && v.isCoeffEnabled() && v.getCoeIdx() != -1) {
                        Variable coeff = this.getVariable(v.getCoeIdx());
                        if (v.m_type != 4) {
                            float f = v.getValueAsFloat() * coeff.getValueAsFloat();
                            writeValue = String.format("%." + v.m_dn + "f", Float.valueOf(f));
                            writeValue = writeValue.replace(",", ".");
                            BigDecimal number = new BigDecimal(writeValue);
                            writeValue = number.stripTrailingZeros().toPlainString();
                        }
                    }
                    sb.append(String.valueOf(v.m_name) + "\t" + writeValue + "\r\n");
                    md5.append(String.valueOf(v.m_name) + "/" + writeValue + ";");
                }
            }
            catch (Exception eeeee) {
                eeeee.printStackTrace(System.out);
            }
            ++i;
        }
        sb.append("MD5\t" + Md5.getHexDigest(md5.toString()) + "\r\n");
        try {
            Utils.writeToFile(filename, sb.toString());
        }
        catch (Exception e) {
            System.out.println("Errore scrittura file " + e.getMessage());
        }
    }

    public Variable getVariable(int pos) {
        if (pos < 0) {
            return null;
        }
        if (this.variables.size() == 0) {
            return null;
        }
        if (pos >= this.variables.size()) {
            return null;
        }
        return this.variables.get(pos);
    }

    public String getRetainVariablesAt(int pos) {
        return this.retainVariables.get(pos);
    }

    public Variable getVariable(String name) {
        for (Variable v : this.variables) {
            if (!name.equals(v.m_name)) continue;
            return v;
        }
        return null;
    }

    public void addVariable(Variable var) {
        this.variables.add(var);
        if (var.m_saved_eeprom) {
            this.retainVariables.add(var.m_name);
        }
    }
}

