/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.console;

import it.sirius.utils.Hex;
import it.sirius.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Variable {
    public int[] value = new int[4];
    public String m_str_value;
    public int m_type = 2;
    public boolean m_isunsigned = true;
    public int m_index;
    public boolean m_saved_eeprom;
    public boolean m_ishex = false;
    public boolean m_isrw;
    public boolean m_ispresent = false;
    public int m_dn = 7;
    public String m_name = "";
    public String m_descr = "";
    public String m_unitofmeasure = "";
    private int m_coeidx = 255;

    public Variable() {
        int i = 0;
        while (i < this.value.length) {
            this.value[i] = -1;
            ++i;
        }
    }

    public boolean isCoeffEnabled() {
        return this.m_coeidx != 255;
    }

    public int getCoeIdx() {
        return this.m_coeidx;
    }

    public void setCoeIdx(int coeidx) {
        if (this.m_type == 4 || this.m_type == 5) {
            assert (this.m_coeidx == 255);
            return;
        }
        this.m_coeidx = coeidx;
    }

    public String getValueAsString() {
        String v = "";
        byte[] bytes = null;
        int tmpI = -1;
        switch (this.m_type) {
            case 4: {
                v = this.m_str_value;
                break;
            }
            case 0: {
                bytes = new byte[]{(byte)this.value[0]};
                if (this.m_ishex) {
                    v = "0x" + Hex.byteArrayToHex(bytes);
                    break;
                }
                tmpI = this.m_isunsigned ? ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).get() & 0xFF : (int)ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).get();
                v = Integer.toString(tmpI);
                break;
            }
            case 1: {
                bytes = new byte[2];
                int i = 0;
                while (i < 2) {
                    bytes[i] = (byte)this.value[i];
                    ++i;
                }
                if (this.m_ishex) {
                    v = "0x" + Hex.byteArrayToHex(Utils.flipBytes(bytes));
                    break;
                }
                tmpI = this.m_isunsigned ? ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF : (int)ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
                v = Integer.toString(tmpI);
                break;
            }
            case 2: {
                bytes = new byte[4];
                int i = 0;
                while (i < 4) {
                    bytes[i] = (byte)this.value[i];
                    ++i;
                }
                if (this.m_ishex) {
                    v = "0x" + Hex.byteArrayToHex(Utils.flipBytes(bytes));
                    break;
                }
                if (this.m_isunsigned) {
                    tmpI = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    long tmp = (long)tmpI & 0xFFFFFFFFL;
                    v = Long.toString(tmp);
                    break;
                }
                tmpI = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
                v = Integer.toString(tmpI);
                break;
            }
            case 3: {
                bytes = new byte[4];
                int i = 0;
                while (i < 4) {
                    bytes[i] = (byte)this.value[i];
                    ++i;
                }
                float f = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                v = String.format("%." + this.m_dn + "f", Float.valueOf(f));
                v = v.replace(",", ".");
                break;
            }
        }
        return v;
    }

    public float getValueAsFloat() {
        float v = 1.0f;
        byte[] bytes = null;
        int tmpI = -1;
        switch (this.m_type) {
            case 4: {
                v = 1.0f;
                break;
            }
            case 0: {
                bytes = new byte[1];
                int i = 0;
                while (i < 1) {
                    bytes[i] = (byte)this.value[i];
                    ++i;
                }
                tmpI = this.m_isunsigned ? ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).get() & 0xFF : (int)ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).get();
                v = new Float(tmpI).floatValue();
                break;
            }
            case 1: {
                bytes = new byte[2];
                int i = 0;
                while (i < 2) {
                    bytes[i] = (byte)this.value[i];
                    ++i;
                }
                tmpI = this.m_isunsigned ? ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF : (int)ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
                v = new Float(tmpI).floatValue();
                break;
            }
            case 2: {
                bytes = new byte[4];
                int i = 0;
                while (i < 4) {
                    bytes[i] = (byte)this.value[i];
                    ++i;
                }
                if (this.m_isunsigned) {
                    tmpI = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    long tmp = (long)tmpI & 0xFFFFFFFFL;
                    v = new Float(tmp).floatValue();
                    break;
                }
                tmpI = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
                v = new Float(tmpI).floatValue();
                break;
            }
            case 3: {
                bytes = new byte[4];
                int i = 0;
                while (i < 4) {
                    bytes[i] = (byte)this.value[i];
                    ++i;
                }
                v = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                break;
            }
        }
        return v;
    }
}

