/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.console;

import it.sirius.console.Commands;
import it.sirius.console.DataPacket;
import it.sirius.console.SerialReceiver;
import it.sirius.console.TimeoutTimer;
import it.sirius.console.Variable;
import it.sirius.db.Database;
import javax.swing.JProgressBar;
import jssc.SerialPort;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;

public class Serial {
    private static SerialPort serialPort;
    public static final int RX_BUFFER_LENGTH = 1024;
    public static byte[] rxBuffer;
    public static int rxIn;
    public static int rxOut;
    private static boolean RAW_DATA;
    public static TimeoutTimer timer;
    public static SerialReceiver sr;

    static {
        rxBuffer = new byte[1024];
        RAW_DATA = false;
    }

    public static void openConnection(String portName, int baudrate) throws SerialPortException {
        serialPort = new SerialPort(portName);
        if (!serialPort.openPort()) {
            throw new SerialPortException(serialPort, "openConnection", "cannot open port");
        }
        if (!serialPort.setParams(baudrate, 8, 1, 0)) {
            throw new SerialPortException(serialPort, "openConnection", "cannot set params");
        }
        sr = new SerialReceiver();
        serialPort.addEventListener((SerialPortEventListener)sr);
        rxIn = 0;
        rxOut = 0;
        timer = new TimeoutTimer();
    }

    public static boolean isOpened() {
        return serialPort != null && serialPort.isOpened();
    }

    public static void closeConnection() throws SerialPortException, InterruptedException {
        if (timer != null) {
            timer.stopTimer();
            timer = null;
        }
        if (serialPort != null && serialPort.isOpened()) {
            try {
                serialPort.purgePort(4);
                serialPort.removeEventListener();
                serialPort.closePort();
                serialPort = null;
            }
            catch (Exception e) {
                serialPort = null;
                throw e;
            }
        }
    }

    public static boolean purge() {
        try {
            return serialPort.purgePort(4);
        }
        catch (SerialPortException serialPortException) {
            return false;
        }
    }

    public static byte[] readBytes(int bytesCount) throws SerialPortException, SerialPortTimeoutException {
        return serialPort.readBytes(bytesCount);
    }

    public static boolean writeBytes(byte[] bytes) throws SerialPortException {
        return serialPort.writeBytes(bytes);
    }

    public static int getInputBufferBytesCount() throws SerialPortException {
        return serialPort.getInputBufferBytesCount();
    }

    public static boolean sendOnDb(int value) {
        try {
            return serialPort.writeBytes(Commands.getCommandSendOnDb(value));
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendReboot() {
        try {
            return Serial.writeBytes(Commands.getCommandSendReboot());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendWhoAmI() {
        try {
            return Serial.writeBytes(Commands.getCommandSendWhoAmI());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendJumpToApplication() {
        try {
            return Serial.writeBytes(Commands.getCommandSendJump());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendSetJumpFlag(byte value) {
        try {
            return Serial.writeBytes(Commands.getCommandSendSetJumpFlag(value));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean sendUploadStart() {
        try {
            return Serial.writeBytes(Commands.getCommandSendUploadStart());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendUploadReady(int blockNumber) {
        try {
            return Serial.writeBytes(Commands.getCommandUploadReady(blockNumber));
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendUploadFrame(byte[] frame) {
        try {
            return Serial.writeBytes(Commands.getCommandUploadFrame(frame));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean sendReadVarString(String name) {
        try {
            byte[] bytes = Commands.getCommandsendReadVarString(name);
            return serialPort.writeBytes(bytes);
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendWriteVarString(String name, String value) {
        try {
            return serialPort.writeBytes(Commands.getCommandSendWriteVarString(name, value));
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static DataPacket getSerialResponse(byte command, long timeout) throws Exception {
        TimeoutTimer.timeout = 0L;
        time = 0L;
        Commands.packet = null;
        ** GOTO lbl17
        {
            b = Serial.rxBuffer[Serial.rxOut++];
            if (Serial.rxOut >= 1024) {
                Serial.rxOut = 0;
            }
            if (Commands.analizePacket(b, new byte[]{command}, Serial.RAW_DATA)) {
                time = 0L;
                TimeoutTimer.timeout = 0L;
                return Commands.packet;
            }
            Thread.sleep(1L);
            do {
                if (Serial.rxOut != Serial.rxIn) continue block0;
                Thread.sleep(1L);
                time = TimeoutTimer.timeout;
lbl17:
                // 2 sources

            } while (time < timeout);
        }
        time = 0L;
        TimeoutTimer.timeout = 0L;
        return null;
    }

    public static boolean sendDisplayReboot() {
        try {
            return serialPort.writeBytes(Commands.getCommandSendDisplayReboot());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendDisplayUpdateReady() {
        try {
            return serialPort.writeBytes(Commands.getCommandSendDisplayUpdateReady());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendDisplayUpdateEOT() {
        try {
            return serialPort.writeBytes(Commands.getCommandSendDisplayUpdateEOT());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendDisplayUdpateEnd() {
        try {
            return serialPort.writeBytes(Commands.getCommandSendDisplayUpdateEnd());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static boolean sendBleCommand(String command) {
        boolean result = false;
        try {
            DataPacket sp;
            rxIn = 0;
            rxOut = 0;
            RAW_DATA = true;
            if (serialPort.writeBytes(command.getBytes()) && (sp = Serial.getSerialResponse((byte)0, 1000L)) != null) {
                String tmp = new String(sp.data);
                tmp = tmp.trim();
                result = tmp.endsWith("00");
            }
            RAW_DATA = false;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean sendDbType() {
        try {
            return Serial.writeBytes(Commands.getCommandSendDbType());
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    public static float getDatabaseVersion() {
        float ver = -1.0f;
        Serial.sendDbType();
        try {
            DataPacket db = Serial.getSerialResponse((byte)18, 100L);
            if (db == null) {
                return ver;
            }
            String version = new String(db.data);
            ver = Float.parseFloat(version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ver;
    }

    public static boolean sendReadDb(int index, boolean extended) {
        try {
            return serialPort.writeBytes(Commands.getCommandSendReadDb(index, extended));
        }
        catch (SerialPortException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Database getDatabase(JProgressBar pb) {
        boolean dnPresent = true;
        boolean extended = false;
        float dbVersion = Serial.getDatabaseVersion();
        System.out.println("Database version = " + dbVersion);
        if ((double)dbVersion < 0.0) {
            dnPresent = false;
        }
        if (dbVersion >= 1.05f) {
            dnPresent = true;
            extended = true;
        }
        Database db = new Database(dbVersion, dnPresent);
        int index = 0;
        int retry = 0;
        while (index < 1700) {
            try {
                System.out.println("index = " + index);
                Class<Serial> clazz = Serial.class;
                // MONITORENTER : it.sirius.console.Serial.class
                Serial.sendReadDb(index, extended);
                // MONITOREXIT : clazz
                DataPacket sp = Serial.getSerialResponse(new byte[]{4, 8, 35}, 500L);
                if (sp != null) {
                    if (sp.len == 0) break;
                    Commands.analizeCmdRdDb(sp, db);
                    if (pb != null) {
                        pb.setValue(index);
                    }
                    ++index;
                    retry = 0;
                } else {
                    ++retry;
                }
            }
            catch (Exception e) {
                ++retry;
            }
            if (retry != 5) continue;
            db = null;
            break;
        }
        if (pb == null) return db;
        pb.setValue(1700);
        return db;
    }

    /*
     * Unable to fully structure code
     */
    public static DataPacket getSerialResponse(byte[] commands, long timeout) throws Exception {
        dp = null;
        TimeoutTimer.timeout = 0L;
        time = 0L;
        ** GOTO lbl18
        {
            b = Serial.rxBuffer[Serial.rxOut++];
            if (Serial.rxOut >= 1024) {
                Serial.rxOut = 0;
            }
            if (Commands.analizePacket(b, commands)) {
                dp = Commands.packet;
                time = 0L;
                TimeoutTimer.timeout = 0L;
                return dp;
            }
            Thread.sleep(1L);
            do {
                if (Serial.rxOut != Serial.rxIn) continue block0;
                Thread.sleep(1L);
                time = TimeoutTimer.timeout;
lbl18:
                // 2 sources

            } while (time < timeout);
        }
        time = 0L;
        TimeoutTimer.timeout = 0L;
        return dp;
    }

    public static boolean isNewWriteMethod() {
        boolean result = false;
        Serial.sendReadVarString("HWVer");
        try {
            if (Serial.getSerialResponse((byte)22, 100L) != null) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return result;
    }

    public static Variable getCoexVariable(int index, boolean isDnPresent, boolean extended) {
        Variable v = null;
        try {
            Serial.sendReadDb(index, extended);
            DataPacket sp = Serial.getSerialResponse(new byte[]{4, 8, 35}, 200L);
            if (sp != null) {
                v = Commands.analizeCoexVariable(sp, isDnPresent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public static boolean sendWriteVar(int index, byte[] value, int size, boolean extended) {
        try {
            return serialPort.writeBytes(Commands.getCommandSendWriteVar(index, value, size, extended));
        }
        catch (SerialPortException e) {
            return false;
        }
    }
}

