/*
 * Decompiled with CFR 0.152.
 */
package it.sirius.console;

import it.sirius.BaseConstants;
import it.sirius.console.DataPacket;
import it.sirius.console.Variable;
import it.sirius.db.Database;
import it.sirius.db.Value;
import it.sirius.utils.Crc16Ccitt;

public class Commands {
    private static int cnt = 0;
    public static BaseConstants.ReceiveStatus rs = BaseConstants.ReceiveStatus.WAIT_CMD;
    public static DataPacket packet = null;

    private static boolean isCmd(byte cmd) {
        int c = cmd & 0xFF;
        return c >= 2 && c <= 181;
    }

    public static boolean analizePacket(byte b, byte[] commands, boolean isRawData) {
        boolean result = false;
        if (isRawData) {
            switch (rs) {
                case WAIT_CMD: {
                    packet = new DataPacket();
                    Commands.packet.cmd = (byte)-1;
                    Commands.packet.chksum = (byte)-1;
                    cnt = 0;
                    Commands.packet.data[Commands.cnt++] = b;
                    rs = BaseConstants.ReceiveStatus.WAIT_DATA;
                    break;
                }
                case WAIT_DATA: {
                    if ((char)b == '\r') {
                        rs = BaseConstants.ReceiveStatus.WAIT_CMD;
                        return true;
                    }
                    Commands.packet.data[Commands.cnt++] = b;
                    break;
                }
                default: {
                    rs = BaseConstants.ReceiveStatus.WAIT_CMD;
                    break;
                }
            }
        } else {
            block4 : switch (rs) {
                case WAIT_CMD: {
                    packet = null;
                    if (!Commands.isCmd(b)) break;
                    packet = new DataPacket();
                    Commands.packet.cmd = b;
                    Commands.packet.chksum = b;
                    rs = BaseConstants.ReceiveStatus.WAIT_LEN;
                    break;
                }
                case WAIT_LEN: {
                    Commands.packet.len = b;
                    if (Commands.packet.len != 0) {
                        Commands.packet.chksum = (byte)(Commands.packet.chksum ^ b);
                        cnt = 0;
                        rs = BaseConstants.ReceiveStatus.WAIT_DATA;
                        break;
                    }
                    rs = BaseConstants.ReceiveStatus.WAIT_CHKSUM;
                    break;
                }
                case WAIT_DATA: {
                    if (++cnt >= Commands.packet.len) {
                        rs = BaseConstants.ReceiveStatus.WAIT_CHKSUM;
                    }
                    Commands.packet.chksum = (byte)(Commands.packet.chksum ^ b);
                    Commands.packet.data[Commands.cnt - 1] = b;
                    break;
                }
                case WAIT_CHKSUM: {
                    if (b != Commands.packet.chksum) {
                        rs = BaseConstants.ReceiveStatus.WAIT_FREE;
                        break;
                    }
                    rs = BaseConstants.ReceiveStatus.WAIT_CMD;
                    result = false;
                    byte[] byArray = commands;
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte c = byArray[n2];
                        if (c == Commands.packet.cmd) {
                            result = true;
                            break block4;
                        }
                        ++n2;
                    }
                    break;
                }
                case WAIT_FREE: {
                    rs = BaseConstants.ReceiveStatus.WAIT_CMD;
                }
            }
        }
        return result;
    }

    public static byte[] getCommandSendOnDb(int value) {
        byte[] buffer;
        buffer = new byte[]{17, 1, (byte)value, (byte)(buffer[0] ^ buffer[1] ^ buffer[2])};
        return buffer;
    }

    public static byte[] getCommandsendReadVarString(String name) {
        int i = 0;
        byte[] buffer = new byte[36];
        buffer[i++] = 22;
        int chksum = buffer[0];
        buffer[i++] = (byte)(name.length() + 1);
        byte[] tmp = name.getBytes();
        int j = 0;
        while (j < tmp.length) {
            buffer[i++] = tmp[j];
            ++j;
        }
        buffer[i++] = 0;
        j = 1;
        while (j < i) {
            chksum ^= buffer[j];
            ++j;
        }
        buffer[i++] = (byte)chksum;
        return buffer;
    }

    public static byte[] getCommandSendWriteVarString(String name, String value) {
        int i = 0;
        byte[] v = value.getBytes();
        byte[] buffer = new byte[name.length() + v.length + 5];
        buffer[i++] = 23;
        int chksum = buffer[0];
        buffer[i++] = (byte)(name.length() + v.length + 2);
        byte[] tmp = name.getBytes();
        int j = 0;
        while (j < tmp.length) {
            buffer[i++] = tmp[j];
            ++j;
        }
        buffer[i++] = 0;
        j = 0;
        while (j < v.length) {
            buffer[i++] = v[j];
            ++j;
        }
        buffer[i++] = 0;
        j = 1;
        while (j < i) {
            chksum ^= buffer[j];
            ++j;
        }
        buffer[i++] = (byte)chksum;
        return buffer;
    }

    public static byte[] getCommandSendWhoAmI() {
        byte[] buffer = new byte[]{-80, 0, -80};
        return buffer;
    }

    public static byte[] getCommandSendReboot() {
        byte[] buffer = new byte[]{12, 0, 12};
        return buffer;
    }

    public static byte[] getCommandSendJump() {
        byte[] buffer = new byte[]{-75, 0, -75};
        return buffer;
    }

    public static byte[] getCommandSendSetJumpFlag(byte value) {
        byte[] buffer;
        buffer = new byte[]{-74, 1, value, (byte)(buffer[0] ^ buffer[1] ^ buffer[2])};
        return buffer;
    }

    public static byte[] getCommandSendUploadStart() {
        byte[] buffer = new byte[]{-79, 0, -79};
        return buffer;
    }

    public static byte[] getCommandUploadReady(int blockNumber) {
        byte[] buffer = new byte[6];
        byte chksum = 0;
        buffer[0] = -78;
        buffer[1] = 3;
        chksum = (byte)(buffer[0] ^ buffer[1]);
        buffer[2] = -52;
        chksum = (byte)(chksum ^ buffer[2]);
        buffer[3] = (byte)(blockNumber >> 8 & 0xFF);
        chksum = (byte)(chksum ^ buffer[3]);
        buffer[4] = (byte)(blockNumber & 0xFF);
        buffer[5] = chksum = (byte)(chksum ^ buffer[4]);
        return buffer;
    }

    public static byte[] getCommandUploadFrame(byte[] frame) {
        int len = frame.length;
        byte[] buffer = new byte[len + 4];
        byte chksum = 0;
        int i = 0;
        buffer[i++] = -77;
        chksum = buffer[0];
        buffer[i++] = (byte)(len >> 8 & 0xFF);
        buffer[i++] = (byte)(len & 0xFF);
        int j = 0;
        while (j < frame.length) {
            buffer[i++] = frame[j];
            ++j;
        }
        chksum = buffer[0];
        j = 1;
        while (j < i) {
            chksum = (byte)(chksum ^ buffer[j]);
            ++j;
        }
        buffer[i++] = chksum;
        return buffer;
    }

    public static byte[] getCommandSendDisplayReboot() {
        byte[] buffer = new byte[]{64, 0, 64};
        return buffer;
    }

    public static byte[] getCommandSendDisplayUpdateReady() {
        byte[] buffer = new byte[]{65, 0, 65};
        return buffer;
    }

    public static byte[] getCommandSendDisplayUpdateEOT() {
        byte[] buffer = new byte[]{68, 0, 68};
        return buffer;
    }

    public static byte[] createUploadStartPacket(int dataSize, int streamSize) {
        String fileName = "display.bin";
        String fileSize = String.valueOf(streamSize);
        byte[] data = new byte[dataSize];
        int i = 0;
        while (i < fileName.length()) {
            data[i] = fileName.getBytes()[i];
            ++i;
        }
        data[i] = 0;
        int j = 0;
        while (j < fileSize.length()) {
            data[i + 1 + j] = fileSize.getBytes()[j];
            ++j;
        }
        data[i + 1 + j] = 0;
        int k = i + 1 + j + 1;
        while (k < dataSize) {
            data[k] = 0;
            ++k;
        }
        return Commands.createUploadRunPacket(data, (byte)0, (byte)-1);
    }

    public static byte[] createUploadEndPacket(int dataSize) {
        byte[] data = new byte[dataSize];
        return Commands.createUploadRunPacket(data, (byte)0, (byte)-1);
    }

    public static byte[] createUploadRunPacket(byte[] data, byte packetNumber, byte invertedPacketNumber) {
        Crc16Ccitt crc16Ccitt = new Crc16Ccitt(0);
        byte[] CRC = crc16Ccitt.computeChecksumBytes(data);
        byte[] inner = new byte[3 + data.length + CRC.length];
        int z = 0;
        inner[z++] = -89;
        inner[z++] = packetNumber;
        inner[z++] = invertedPacketNumber;
        int jj = 0;
        while (jj < data.length) {
            inner[z++] = data[jj];
            ++jj;
        }
        jj = 0;
        while (jj < CRC.length) {
            inner[z++] = CRC[jj];
            ++jj;
        }
        return inner;
    }

    public static byte[] getCommandSendDisplayUpdateEnd() {
        byte[] buffer = new byte[]{70, 0, 70};
        return buffer;
    }

    public static boolean analizePacket(byte b, byte[] commands) {
        boolean result = false;
        block0 : switch (rs) {
            case WAIT_CMD: {
                packet = null;
                if (!Commands.isCmd(b)) break;
                packet = new DataPacket();
                Commands.packet.cmd = b;
                Commands.packet.chksum = b;
                rs = BaseConstants.ReceiveStatus.WAIT_LEN;
                break;
            }
            case WAIT_LEN: {
                Commands.packet.len = b;
                if (Commands.packet.len != 0) {
                    Commands.packet.chksum = (byte)(Commands.packet.chksum ^ b);
                    cnt = 0;
                    rs = BaseConstants.ReceiveStatus.WAIT_DATA;
                    break;
                }
                rs = BaseConstants.ReceiveStatus.WAIT_CHKSUM;
                break;
            }
            case WAIT_DATA: {
                if (++cnt >= Commands.packet.len) {
                    rs = BaseConstants.ReceiveStatus.WAIT_CHKSUM;
                }
                Commands.packet.chksum = (byte)(Commands.packet.chksum ^ b);
                Commands.packet.data[Commands.cnt - 1] = b;
                break;
            }
            case WAIT_CHKSUM: {
                rs = BaseConstants.ReceiveStatus.WAIT_CMD;
                if (b != Commands.packet.chksum) break;
                result = false;
                byte[] byArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    byte c = byArray[n2];
                    if (c == Commands.packet.cmd) {
                        result = true;
                        break block0;
                    }
                    ++n2;
                }
                break;
            }
        }
        return result;
    }

    public static DataPacket analizePacket(byte[] raw_data, byte[] commands) {
        int cnt = 0;
        int chksum = 0;
        BaseConstants.ReceiveStatus r = BaseConstants.ReceiveStatus.WAIT_CMD;
        DataPacket packet = new DataPacket();
        int i = 0;
        while (i < raw_data.length) {
            switch (r) {
                case WAIT_CMD: {
                    if (!Commands.isCmd(raw_data[i])) break;
                    r = BaseConstants.ReceiveStatus.WAIT_LEN;
                    packet.cmd = raw_data[i];
                    chksum = raw_data[i];
                    break;
                }
                case WAIT_LEN: {
                    packet.len = raw_data[i];
                    if (packet.len == 0) {
                        r = BaseConstants.ReceiveStatus.WAIT_CHKSUM;
                        break;
                    }
                    chksum ^= raw_data[i];
                    cnt = 0;
                    r = BaseConstants.ReceiveStatus.WAIT_DATA;
                    break;
                }
                case WAIT_DATA: {
                    if (++cnt >= packet.len) {
                        r = BaseConstants.ReceiveStatus.WAIT_CHKSUM;
                    }
                    chksum ^= raw_data[i];
                    packet.data[cnt - 1] = raw_data[i];
                    break;
                }
                case WAIT_CHKSUM: {
                    r = BaseConstants.ReceiveStatus.WAIT_CMD;
                    if (raw_data[i] != chksum) break;
                    packet.chksum = (byte)chksum;
                    rs = BaseConstants.ReceiveStatus.WAIT_CMD;
                    byte[] byArray = commands;
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte c = byArray[n2];
                        if (c == packet.cmd) {
                            return packet;
                        }
                        ++n2;
                    }
                    break;
                }
            }
            ++i;
        }
        return null;
    }

    public static void analizeCmdRdDb(DataPacket packet, Database db) {
        char c;
        int pos_data = 0;
        int index = -1;
        if (packet.len == 0) {
            return;
        }
        if (packet.cmd == 35) {
            index = packet.data[pos_data++] & 0xFF;
            index |= (packet.data[pos_data++] & 0xFF) << 8;
        } else {
            index = packet.data[pos_data++] & 0xFF;
            if (packet.cmd == 8) {
                index += 255;
            }
        }
        if (db.getVariable(index) != null) {
            return;
        }
        Variable var = new Variable();
        var.m_index = index;
        var.m_saved_eeprom = packet.data[pos_data++] >= 1;
        switch (packet.data[pos_data++] & 0xFF) {
            case 0: {
                var.m_isunsigned = false;
                break;
            }
            case 1: {
                var.m_isunsigned = true;
                break;
            }
            case 2: {
                var.m_ishex = true;
            }
        }
        var.m_type = packet.data[pos_data++] & 0xFF;
        if (db.isDnPresent()) {
            var.m_isrw = packet.data[pos_data++] != 1;
            var.m_dn = packet.data[pos_data++] & 0xFF;
            var.setCoeIdx(255);
        } else {
            var.m_isrw = true;
            var.m_dn = 7;
        }
        switch (var.m_type) {
            case 0: {
                int z = 0;
                while (z < 1) {
                    var.value[z] = packet.data[pos_data++] & 0xFF;
                    ++z;
                }
                break;
            }
            case 1: {
                int z = 0;
                while (z < 2) {
                    var.value[z] = packet.data[pos_data++] & 0xFF;
                    ++z;
                }
                break;
            }
            case 3: {
                int z = 0;
                while (z < 4) {
                    var.value[z] = packet.data[pos_data++] & 0xFF;
                    ++z;
                }
                break;
            }
            case 2: {
                int z = 0;
                while (z < 4) {
                    var.value[z] = packet.data[pos_data++] & 0xFF;
                    ++z;
                }
                break;
            }
            case 4: {
                String str_val = "";
                int j = 0;
                while (j < 32) {
                    c = (char)packet.data[pos_data];
                    if (c == '\u0000') {
                        ++pos_data;
                        break;
                    }
                    str_val = String.valueOf(str_val) + c;
                    ++pos_data;
                    ++j;
                }
                var.m_str_value = str_val;
            }
        }
        String tmpStr = "";
        int i = 0;
        while (i < 128) {
            if ((c = (char)packet.data[pos_data++]) == '\u0000') break;
            tmpStr = String.valueOf(tmpStr) + c;
            ++i;
        }
        var.m_descr = new String(tmpStr);
        tmpStr = "";
        i = 0;
        while (i < 128) {
            if ((c = (char)packet.data[pos_data++]) == '\u0000') break;
            tmpStr = String.valueOf(tmpStr) + c;
            ++i;
        }
        var.m_name = new String(tmpStr);
        if (db.isDnPresent()) {
            Variable v_ing;
            var.setCoeIdx(packet.data[pos_data]);
            if (var.isCoeffEnabled() && var.getCoeIdx() != -1 && (v_ing = db.getVariable(var.getCoeIdx())) != null) {
                var.m_unitofmeasure = v_ing.m_name;
            }
        } else {
            var.setCoeIdx(255);
            tmpStr = "";
            i = 0;
            while (i < 128) {
                c = (char)packet.data[pos_data];
                if (c == '\u0000') {
                    ++pos_data;
                    break;
                }
                tmpStr = String.valueOf(tmpStr) + c;
                ++i;
            }
            var.m_unitofmeasure = new String(tmpStr);
        }
        db.addVariable(var);
    }

    public static Variable analizeCoexVariable(DataPacket packet, boolean isDnPresent) {
        char c;
        int pos_data = 0;
        if (packet.len == 0) {
            return null;
        }
        int index = packet.data[pos_data++] & 0xFF;
        if (packet.cmd == 8) {
            index += 255;
        }
        Variable var = new Variable();
        var.m_index = index;
        var.m_saved_eeprom = packet.data[pos_data++] >= 1;
        switch (packet.data[pos_data++] & 0xFF) {
            case 0: {
                var.m_isunsigned = false;
                break;
            }
            case 1: {
                var.m_isunsigned = true;
                break;
            }
            case 2: {
                var.m_ishex = true;
            }
        }
        var.m_type = packet.data[pos_data++] & 0xFF;
        if (isDnPresent) {
            var.m_isrw = packet.data[pos_data++] != 1;
            var.m_dn = packet.data[pos_data++] & 0xFF;
            var.setCoeIdx(255);
        } else {
            var.m_isrw = true;
            var.m_dn = 7;
        }
        switch (var.m_type) {
            case 0: {
                int z = 0;
                while (z < 1) {
                    var.value[z] = packet.data[pos_data++] & 0xFF;
                    ++z;
                }
                break;
            }
            case 1: {
                int z = 0;
                while (z < 2) {
                    var.value[z] = packet.data[pos_data++] & 0xFF;
                    ++z;
                }
                break;
            }
            case 3: {
                int z = 0;
                while (z < 4) {
                    var.value[z] = packet.data[pos_data++] & 0xFF;
                    ++z;
                }
                break;
            }
            case 2: {
                int z = 0;
                while (z < 4) {
                    var.value[z] = packet.data[pos_data++] & 0xFF;
                    ++z;
                }
                break;
            }
            case 4: {
                String str_val = "";
                int j = 0;
                while (j < 32) {
                    c = (char)packet.data[pos_data];
                    if (c == '\u0000') {
                        ++pos_data;
                        break;
                    }
                    str_val = String.valueOf(str_val) + c;
                    ++pos_data;
                    ++j;
                }
                var.m_str_value = str_val;
            }
        }
        String tmpStr = "";
        int i = 0;
        while (i < 128) {
            if ((c = (char)packet.data[pos_data++]) == '\u0000') break;
            tmpStr = String.valueOf(tmpStr) + c;
            ++i;
        }
        var.m_descr = new String(tmpStr);
        tmpStr = "";
        i = 0;
        while (i < 128) {
            if ((c = (char)packet.data[pos_data++]) == '\u0000') break;
            tmpStr = String.valueOf(tmpStr) + c;
            ++i;
        }
        var.m_name = new String(tmpStr);
        if (isDnPresent) {
            var.setCoeIdx(packet.data[pos_data]);
        } else {
            var.setCoeIdx(255);
            tmpStr = "";
            i = 0;
            while (i < 128) {
                c = (char)packet.data[pos_data];
                if (c == '\u0000') {
                    ++pos_data;
                    break;
                }
                tmpStr = String.valueOf(tmpStr) + c;
                ++i;
            }
            var.m_unitofmeasure = new String(tmpStr);
        }
        return var;
    }

    public static byte[] getCommandSendDbType() {
        byte[] buffer = new byte[]{19, 0, 19};
        return buffer;
    }

    public static byte[] getCommandSendReadDb(int index, boolean extended) {
        byte[] buffer = null;
        if (extended) {
            int cmd;
            buffer = new byte[5];
            buffer[0] = cmd = 35;
            buffer[1] = 2;
            buffer[2] = (byte)(index & 0xFF);
            buffer[3] = (byte)(index >> 8 & 0xFF);
            byte chksum = buffer[0];
            chksum = (byte)(chksum ^ buffer[1]);
            chksum = (byte)(chksum ^ buffer[2]);
            buffer[4] = chksum = (byte)(chksum ^ buffer[3]);
        } else {
            int cmd;
            buffer = new byte[4];
            if (index < 255) {
                cmd = 4;
            } else {
                cmd = 8;
                index -= 255;
            }
            buffer[0] = cmd;
            buffer[1] = 1;
            buffer[2] = (byte)index;
            byte chksum = buffer[0];
            chksum = (byte)(chksum ^ buffer[1]);
            buffer[3] = chksum = (byte)(chksum ^ buffer[2]);
        }
        return buffer;
    }

    public static byte[] getCommandSendWriteVarString(Value v) {
        return Commands.getCommandSendWriteVarString(v.getName(), v.getValue().getBytes());
    }

    public static byte[] getCommandSendWriteVarString(String name, byte[] value) {
        int i = 0;
        byte[] buffer = new byte[name.length() + value.length + 5];
        buffer[i++] = 23;
        int chksum = buffer[0];
        buffer[i++] = (byte)(name.length() + value.length + 2);
        byte[] tmp = name.getBytes();
        int j = 0;
        while (j < tmp.length) {
            buffer[i++] = tmp[j];
            ++j;
        }
        buffer[i++] = 0;
        j = 0;
        while (j < value.length) {
            buffer[i++] = value[j];
            ++j;
        }
        buffer[i++] = 0;
        j = 1;
        while (j < i) {
            chksum ^= buffer[j];
            ++j;
        }
        buffer[i++] = (byte)chksum;
        return buffer;
    }

    public static byte[] getCommandSendWriteVar(int index, byte[] value, int size, boolean extended) {
        int chksum;
        int i = 0;
        byte[] buffer = null;
        if (extended) {
            buffer = new byte[size + 5];
            buffer[i++] = 33;
            buffer[i++] = (byte)(size + 2);
            buffer[i++] = (byte)(index & 0xFF);
            buffer[i++] = (byte)(index >> 8 & 0xFF);
            chksum = buffer[0];
            chksum ^= buffer[1];
            chksum ^= buffer[2];
            chksum ^= buffer[3];
        } else {
            int cmd;
            buffer = new byte[size + 4];
            if (index < 255) {
                cmd = 2;
            } else {
                index -= 255;
                cmd = 6;
            }
            buffer[i++] = cmd;
            buffer[i++] = (byte)(size + 1);
            chksum = buffer[0] ^ buffer[1];
            buffer[i++] = (byte)index;
            chksum ^= index;
        }
        int j = 0;
        while (j < size) {
            buffer[i] = value[j];
            chksum ^= buffer[i];
            ++i;
            ++j;
        }
        buffer[i++] = (byte)chksum;
        return buffer;
    }

    public static byte[] getCommandSendWriteFilePacket(byte[] content, int index, int size) {
        int chksum = 0;
        int i = 0;
        byte[] buffer = new byte[content.length + 4 + 2 + 2];
        buffer[i++] = 26;
        buffer[i++] = (byte)(content.length + 1 + 2 + 2);
        buffer[i++] = (byte)(index >> 8 & 0xFF);
        buffer[i++] = (byte)(index & 0xFF);
        buffer[i++] = (byte)(size >> 8 & 0xFF);
        buffer[i++] = (byte)(size & 0xFF);
        int j = 0;
        while (j < content.length) {
            buffer[i++] = content[j];
            ++j;
        }
        buffer[i++] = 0;
        j = 0;
        while (j < i) {
            chksum ^= buffer[j];
            ++j;
        }
        buffer[i++] = (byte)chksum;
        return buffer;
    }

    public static byte[] getCommandSendRebootBios(byte value) {
        byte[] buffer;
        buffer = new byte[]{-68, 1, value, (byte)(buffer[0] ^ buffer[1] ^ buffer[2])};
        return buffer;
    }

    public static byte[] getCommandSendRebootCause() {
        byte[] buffer = new byte[]{-76, 0, -76};
        return buffer;
    }
}

